/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.webcamcapture;

import com.github.sarxos.webcam.Webcam;
import java.awt.Dimension;
import java.util.List;

public class UtilWebcamCapture {
    public static Webcam openDefault(int desiredWidth, int desiredHeight) {
        Webcam webcam = Webcam.getDefault();
        UtilWebcamCapture.adjustResolution(webcam, desiredWidth, desiredHeight);
        webcam.open();
        return webcam;
    }

    public static Webcam openDevice(String deviceName, int desiredWidth, int desiredHeight) {
        Webcam webcam = UtilWebcamCapture.findDevice(deviceName);
        if (webcam == null) {
            throw new IllegalArgumentException("Can't find camera " + deviceName);
        }
        UtilWebcamCapture.adjustResolution(webcam, desiredWidth, desiredHeight);
        webcam.open();
        return webcam;
    }

    public static Webcam findDevice(String deviceName) {
        List found = Webcam.getWebcams();
        for (Webcam cam : found) {
            if (!cam.getName().contains(deviceName)) continue;
            return cam;
        }
        return null;
    }

    public static void adjustResolution(Webcam webcam, int desiredWidth, int desiredHeight) {
        Dimension[] sizes = webcam.getViewSizes();
        int bestError = Integer.MAX_VALUE;
        Dimension best = sizes[0];
        for (Dimension d : sizes) {
            int error = (d.width - desiredWidth) * (d.height - desiredHeight);
            if (error >= bestError) continue;
            bestError = error;
            best = d;
        }
        webcam.setViewSize(best);
    }
}

