/*
 * Copyright (c) 2021, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.feature.orientation.impl;

import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.alg.feature.orientation.OrientationImageAverage;
import boofcv.struct.image.GrayF32;


/**
 *
 * <p>
 * Implementation of {@link boofcv.alg.feature.orientation.OrientationImageAverage} for a specific image type.
 * </p>
 *
 * <p>
 * WARNING: Do not modify. Automatically generated by {@link GenerateImplOrientationImageAverage}.
 * </p>
 *
 * @author Peter Abeles
 */
public class ImplOrientationImageAverage_F32 extends OrientationImageAverage<GrayF32> {

	public ImplOrientationImageAverage_F32(double objectToSample, int radius) {
		super(objectToSample,radius);
	}

	@Override
	public double computeAngle( int c_x , int c_y ) {

		double sumX=0,sumY=0;

		for( int y = rect.y0; y < rect.y1; y++ ) {
			int index = image.startIndex + image.stride*y + rect.x0;
			int indexW = (y-c_y+ sampleRadius)*kerCosine.width + rect.x0-c_x+ sampleRadius;

			for( int x = rect.x0; x < rect.x1; x++ , index++ , indexW++ ) {
				float val = image.data[index];
				sumX += kerCosine.data[indexW]*val;
				sumY += kerSine.data[indexW]*val;
			}
		}

		return Math.atan2(sumY,sumX);
	}

	@Override
	public Class<GrayF32> getImageType() {
		return GrayF32.class;
	}

	@Override
	public RegionOrientation copy() {
		ImplOrientationImageAverage_F32 alg = new ImplOrientationImageAverage_F32(objectToSample,sampleRadius);
		alg.setObjectRadius(objectRadius);
		return alg;
	}
}
