/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.Associate;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public abstract class BaseAssociateSets<Desc>
implements Associate<Desc> {
    Associate<Desc> _associator;
    protected final DogArray<SetStruct> sets;
    protected int countSrc;
    protected int countDst;
    protected final DogArray<AssociatedIndex> matches;
    protected final DogArray_I32 unassociatedSrc = new DogArray_I32();
    protected final DogArray_I32 unassociatedDst = new DogArray_I32();

    protected BaseAssociateSets(Associate<Desc> associator) {
        this._associator = associator;
        this.matches = new DogArray(AssociatedIndex::new);
        this.sets = new DogArray(this::newSetStruct, SetStruct::reset);
    }

    protected SetStruct newSetStruct() {
        return new SetStruct();
    }

    public void clearSource() {
        this.unassociatedSrc.reset();
        this.countSrc = 0;
        for (int i = 0; i < this.sets.size; ++i) {
            ((SetStruct)this.sets.get((int)i)).src.reset();
            ((SetStruct)this.sets.get((int)i)).indexSrc.reset();
        }
    }

    public void clearDestination() {
        this.unassociatedDst.reset();
        this.countDst = 0;
        for (int i = 0; i < this.sets.size; ++i) {
            ((SetStruct)this.sets.get((int)i)).dst.reset();
            ((SetStruct)this.sets.get((int)i)).indexDst.reset();
        }
    }

    protected void saveSetAssociateResults(SetStruct set) {
        int before = this.matches.size;
        FastAccess<AssociatedIndex> setMatches = this._associator.getMatches();
        this.matches.resize(this.matches.size + setMatches.size);
        for (int assocIdx = 0; assocIdx < setMatches.size; ++assocIdx) {
            AssociatedIndex sa = (AssociatedIndex)setMatches.get(assocIdx);
            int inputIdxSrc = set.indexSrc.data[sa.src];
            int inputIdxDst = set.indexDst.data[sa.dst];
            ((AssociatedIndex[])this.matches.data)[before + assocIdx].setTo(inputIdxSrc, inputIdxDst, sa.fitScore);
        }
        DogArray_I32 setUnassociatedSrc = this._associator.getUnassociatedSource();
        before = this.unassociatedSrc.size;
        this.unassociatedSrc.extend(before + setUnassociatedSrc.size);
        for (int i = 0; i < setUnassociatedSrc.size; ++i) {
            this.unassociatedSrc.data[before + i] = set.indexSrc.data[setUnassociatedSrc.get(i)];
        }
        DogArray_I32 setUnassociatedDst = this._associator.getUnassociatedDestination();
        before = this.unassociatedDst.size;
        this.unassociatedDst.extend(before + setUnassociatedDst.size);
        for (int i = 0; i < setUnassociatedDst.size; ++i) {
            this.unassociatedDst.data[before + i] = set.indexDst.data[setUnassociatedDst.get(i)];
        }
    }

    @Override
    public FastAccess<AssociatedIndex> getMatches() {
        return this.matches;
    }

    @Override
    public DogArray_I32 getUnassociatedSource() {
        return this.unassociatedSrc;
    }

    @Override
    public DogArray_I32 getUnassociatedDestination() {
        return this.unassociatedDst;
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this._associator.setMaxScoreThreshold(score);
    }

    @Override
    public MatchScoreType getScoreType() {
        return this._associator.getScoreType();
    }

    @Override
    public boolean uniqueSource() {
        return this._associator.uniqueSource();
    }

    @Override
    public boolean uniqueDestination() {
        return this._associator.uniqueDestination();
    }

    @Override
    public Class<Desc> getDescriptionType() {
        return this._associator.getDescriptionType();
    }

    protected class SetStruct {
        public FastArray<Desc> src;
        public FastArray<Desc> dst;
        public DogArray_I32 indexSrc;
        public DogArray_I32 indexDst;

        protected SetStruct() {
            this.src = new FastArray(BaseAssociateSets.this._associator.getDescriptionType());
            this.dst = new FastArray(BaseAssociateSets.this._associator.getDescriptionType());
            this.indexSrc = new DogArray_I32();
            this.indexDst = new DogArray_I32();
        }

        public void reset() {
            this.src.reset();
            this.dst.reset();
            this.indexSrc.reset();
            this.indexDst.reset();
        }
    }
}

