/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.convert.ConvertTupleDesc;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;

public class DetectDescribeConvertTuple<Image extends ImageBase<Image>, In extends TupleDesc<In>, Out extends TupleDesc<Out>>
implements DetectDescribePoint<Image, Out> {
    DetectDescribePoint<Image, In> detector;
    ConvertTupleDesc<In, Out> converter;
    Out out;

    public DetectDescribeConvertTuple(DetectDescribePoint<Image, In> detector, ConvertTupleDesc<In, Out> converter) {
        this.detector = detector;
        this.converter = converter;
        this.out = converter.createOutput();
    }

    @Override
    public Out createDescription() {
        return this.converter.createOutput();
    }

    @Override
    public Class<Out> getDescriptionType() {
        return this.converter.getOutputType();
    }

    @Override
    public Out getDescription(int index) {
        this.converter.convert(this.detector.getDescription(index), this.out);
        return this.out;
    }

    @Override
    public int getNumberOfSets() {
        return this.detector.getNumberOfSets();
    }

    @Override
    public int getSet(int index) {
        return this.detector.getSet(index);
    }

    @Override
    public int getNumberOfFeatures() {
        return this.detector.getNumberOfFeatures();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.detector.getLocation(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.detector.getRadius(featureIndex);
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.detector.getOrientation(featureIndex);
    }

    @Override
    public void detect(Image input) {
        this.detector.detect(input);
    }

    @Override
    public boolean hasScale() {
        return this.detector.hasScale();
    }

    @Override
    public boolean hasOrientation() {
        return this.detector.hasOrientation();
    }

    @Override
    public ImageType<Image> getInputType() {
        return this.detector.getInputType();
    }
}

