/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.segmentation;

import boofcv.abst.segmentation.ImageSuperpixels;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.segmentation.ComputeRegionMeanColor;
import boofcv.alg.segmentation.ImageSegmentationOps;
import boofcv.alg.segmentation.ms.MergeSmallRegions;
import boofcv.alg.segmentation.watershed.WatershedVincentSoille1991;
import boofcv.core.image.GConvertImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.feature.ColorQueue_F32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;

public class Watershed_to_ImageSuperpixels<T extends ImageBase<T>>
implements ImageSuperpixels<T> {
    private final WatershedVincentSoille1991 alg;
    private final ConnectRule rule;
    private final GrayU8 converted = new GrayU8(1, 1);
    private MergeSmallRegions<GrayU8> pruneSmall;
    private final DogArray_I32 regionMemberCount = new DogArray_I32();
    private final DogArray<float[]> regionColor = new ColorQueue_F32(1);
    private int numRegions;
    private ImageType<T> imageType;

    public Watershed_to_ImageSuperpixels(WatershedVincentSoille1991 alg, int minimumSize, ConnectRule rule) {
        this.alg = alg;
        this.rule = rule;
        if (minimumSize > 0) {
            this.pruneSmall = new MergeSmallRegions<GrayU8>(minimumSize, rule, new ComputeRegionMeanColor.U8());
        }
    }

    @Override
    public void segment(T input, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, (ImageBase)output);
        this.converted.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        GConvertImage.convert(input, (ImageBase)this.converted);
        this.alg.process(this.converted);
        this.alg.removeWatersheds();
        this.numRegions = this.alg.getTotalRegions();
        GrayS32 pixelToRegion = this.alg.getOutput();
        if (this.pruneSmall != null) {
            this.regionMemberCount.resize(this.numRegions);
            this.regionColor.resize(this.numRegions);
            ImageSegmentationOps.countRegionPixels(pixelToRegion, this.numRegions, this.regionMemberCount.data);
            this.pruneSmall.process(this.converted, pixelToRegion, this.regionMemberCount, this.regionColor);
            this.numRegions = this.regionMemberCount.size();
        }
        output.setTo((ImageGray)pixelToRegion);
    }

    @Override
    public int getTotalSuperpixels() {
        return this.numRegions;
    }

    @Override
    public ConnectRule getRule() {
        return this.rule;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType<T> imageType) {
        this.imageType = imageType;
    }
}

