/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;
import pabeles.concurrency.GrowArray;

public class BackgroundMovingBasic_SB<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingBasic<T, Motion> {
    protected GrayF32 background = new GrayF32(1, 1);
    protected InterpolatePixelS<T> _interpolationInput;
    protected InterpolatePixelS<GrayF32> _interpolationBG;
    protected GImageGray inputWrapper;
    protected GrowArray<Helper> helpers;
    protected Helper helper;

    public BackgroundMovingBasic_SB(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, Class<T> imageType) {
        super(learnRate, threshold, transform, ImageType.single(imageType));
        this._interpolationInput = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)BorderType.EXTENDED);
        this._interpolationBG = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, GrayF32.class);
        this._interpolationBG.setBorder(FactoryImageBorder.single((BorderType)BorderType.EXTENDED, GrayF32.class));
        this._interpolationBG.setImage((ImageBase)this.background);
        this.inputWrapper = FactoryGImageGray.create(imageType);
        this.helpers = new GrowArray(() -> new Helper());
        this.helper = (Helper)this.helpers.grow();
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        ImageMiscOps.fill((GrayF32)this.background, (float)Float.MAX_VALUE);
        this.homeToWorld.setTo(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        ImageMiscOps.fill((GrayF32)this.background, (float)Float.MAX_VALUE);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        int idx0 = y0;
        int idx1 = y1;
        this.helper.updateBackground(x0, idx0, x1, idx1, frame);
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.inputWrapper.wrap(frame);
        boolean idx0 = false;
        int idx1 = ((ImageGray)frame).height;
        this.helper.segment(0, idx1, currentToWorld, frame, segmented);
    }

    public GrayF32 getBackground() {
        return this.background;
    }

    private class Helper {
        private final Point2D_F32 pixel = new Point2D_F32();
        private final Point2Transform2Model_F32<Motion> transform;
        private final InterpolatePixelS<T> interpolationInput;
        private final InterpolatePixelS<GrayF32> interpolationBG;

        public Helper() {
            this.transform = (Point2Transform2Model_F32)BackgroundMovingBasic_SB.this._transform.copyConcurrent();
            this.interpolationInput = BackgroundMovingBasic_SB.this._interpolationInput.copy();
            this.interpolationBG = BackgroundMovingBasic_SB.this._interpolationBG.copy();
            this.interpolationBG.setImage((ImageBase)BackgroundMovingBasic_SB.this.background);
        }

        public void updateBackground(int x0, int y0, int x1, int y1, T frame) {
            this.interpolationInput.setImage(frame);
            float minusLearn = 1.0f - BackgroundMovingBasic_SB.this.learnRate;
            this.transform.setModel((Object)BackgroundMovingBasic_SB.this.worldToCurrent);
            for (int y = y0; y < y1; ++y) {
                int indexBG = BackgroundMovingBasic_SB.this.background.startIndex + y * BackgroundMovingBasic_SB.this.background.stride + x0;
                int x = x0;
                while (x < x1) {
                    this.transform.compute((float)x, (float)y, this.pixel);
                    if (this.pixel.x >= 0.0f && this.pixel.x < (float)((ImageGray)frame).width && this.pixel.y >= 0.0f && this.pixel.y < (float)((ImageGray)frame).height) {
                        float value = this.interpolationInput.get(this.pixel.x, this.pixel.y);
                        float bg = BackgroundMovingBasic_SB.this.background.data[indexBG];
                        BackgroundMovingBasic_SB.this.background.data[indexBG] = bg == Float.MAX_VALUE ? value : minusLearn * bg + BackgroundMovingBasic_SB.this.learnRate * value;
                    }
                    ++x;
                    ++indexBG;
                }
            }
        }

        protected void segment(int y0, int y1, Motion currentToWorld, T frame, GrayU8 segmented) {
            float thresholdSq = BackgroundMovingBasic_SB.this.threshold * BackgroundMovingBasic_SB.this.threshold;
            this.transform.setModel(currentToWorld);
            for (int y = y0; y < y1; ++y) {
                int indexFrame = ((ImageGray)frame).startIndex + y * ((ImageGray)frame).stride;
                int indexSegmented = segmented.startIndex + y * segmented.stride;
                int x = 0;
                while (x < ((ImageGray)frame).width) {
                    this.transform.compute((float)x, (float)y, this.pixel);
                    if (this.pixel.x >= 0.0f && this.pixel.x < (float)BackgroundMovingBasic_SB.this.background.width && this.pixel.y >= 0.0f && this.pixel.y < (float)BackgroundMovingBasic_SB.this.background.height) {
                        float bg = this.interpolationBG.get(this.pixel.x, this.pixel.y);
                        float pixelFrame = BackgroundMovingBasic_SB.this.inputWrapper.getF(indexFrame);
                        if (bg == Float.MAX_VALUE) {
                            segmented.data[indexSegmented] = BackgroundMovingBasic_SB.this.unknownValue;
                        } else {
                            float diff = bg - pixelFrame;
                            segmented.data[indexSegmented] = (byte)(!(diff * diff <= thresholdSq) ? 1 : 0);
                        }
                    } else {
                        segmented.data[indexSegmented] = BackgroundMovingBasic_SB.this.unknownValue;
                    }
                    ++x;
                    ++indexFrame;
                    ++indexSegmented;
                }
            }
        }
    }
}

