/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGmm;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;
import pabeles.concurrency.GrowArray;

public class BackgroundMovingGmm_SB<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGmm<T, Motion> {
    protected GrowArray<Helper> helpers = new GrowArray(() -> new Helper());
    protected Helper helper = (Helper)this.helpers.grow();

    public BackgroundMovingGmm_SB(float learningPeriod, float decayCoef, int maxGaussians, Point2Transform2Model_F32<Motion> transformImageType, ImageType<T> imageType) {
        super(learningPeriod, decayCoef, maxGaussians, transformImageType, imageType);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.common.inputWrapperG.wrap(frame);
        int idx0 = y0;
        int idx1 = y1;
        this.helper.updateBackground(x0, idx0, x1, idx1, frame);
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.common.inputWrapperG.wrap(frame);
        this.common.unknownValue = this.unknownValue;
        boolean idx0 = false;
        int idx1 = ((ImageGray)frame).height;
        this.helper.segment(0, idx1, currentToWorld, frame, segmented);
    }

    private class Helper {
        private final Point2D_F32 pixel = new Point2D_F32();
        private final Point2Transform2Model_F32<Motion> transform;

        public Helper() {
            this.transform = (Point2Transform2Model_F32)BackgroundMovingGmm_SB.this._transform.copyConcurrent();
        }

        public void updateBackground(int x0, int y0, int x1, int y1, T frame) {
            this.transform.setModel((Object)BackgroundMovingGmm_SB.this.worldToCurrent);
            for (int y = y0; y < y1; ++y) {
                float[] modelRow = BackgroundMovingGmm_SB.this.common.model.data[y];
                for (int x = x0; x < x1; ++x) {
                    int indexModel = x * BackgroundMovingGmm_SB.this.common.modelStride;
                    this.transform.compute((float)x, (float)y, this.pixel);
                    int xx = (int)(this.pixel.x + 0.5f);
                    int yy = (int)(this.pixel.y + 0.5f);
                    if (!(this.pixel.x >= 0.0f) || xx >= ((ImageGray)frame).width || !(this.pixel.y >= 0.0f) || yy >= ((ImageGray)frame).height) continue;
                    float pixelValue = BackgroundMovingGmm_SB.this.common.inputWrapperG.unsafe_getF(xx, yy);
                    BackgroundMovingGmm_SB.this.common.updateMixture(pixelValue, modelRow, indexModel);
                }
            }
        }

        protected void segment(int y0, int y1, Motion currentToWorld, T frame, GrayU8 segmented) {
            this.transform.setModel(currentToWorld);
            for (int y = y0; y < y1; ++y) {
                int indexOut = segmented.startIndex + y * segmented.stride;
                int x = 0;
                while (x < ((ImageGray)frame).width) {
                    this.transform.compute((float)x, (float)y, this.pixel);
                    int xx = (int)(this.pixel.x + 0.5f);
                    int yy = (int)(this.pixel.y + 0.5f);
                    if (this.pixel.x >= 0.0f && xx < BackgroundMovingGmm_SB.this.backgroundWidth && this.pixel.y >= 0.0f && yy < BackgroundMovingGmm_SB.this.backgroundHeight) {
                        float pixelValue = BackgroundMovingGmm_SB.this.common.inputWrapperG.unsafe_getF(x, y);
                        float[] modelRow = BackgroundMovingGmm_SB.this.common.model.data[yy];
                        int indexModel = xx * BackgroundMovingGmm_SB.this.common.modelStride;
                        segmented.data[indexOut] = (byte)BackgroundMovingGmm_SB.this.common.checkBackground(pixelValue, modelRow, indexModel);
                    } else {
                        segmented.data[indexOut] = BackgroundMovingGmm_SB.this.unknownValue;
                    }
                    ++x;
                    ++indexOut;
                }
            }
        }
    }
}

