/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.ms;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.segmentation.ms.ClusterLabeledImage;
import boofcv.alg.segmentation.ms.MergeRegionMeanShift;
import boofcv.alg.segmentation.ms.MergeSmallRegions;
import boofcv.alg.segmentation.ms.SegmentMeanShiftSearch;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.Stoppable;
import org.jetbrains.annotations.Nullable;

public class SegmentMeanShift<T extends ImageBase<T>>
implements Stoppable {
    SegmentMeanShiftSearch<T> search;
    MergeRegionMeanShift merge;
    ClusterLabeledImage segment;
    @Nullable
    MergeSmallRegions<T> prune;
    volatile boolean stopRequested = false;

    public SegmentMeanShift(SegmentMeanShiftSearch<T> search, MergeRegionMeanShift merge, @Nullable MergeSmallRegions<T> prune, ConnectRule connectRule) {
        this.search = search;
        this.merge = merge;
        this.prune = prune;
        this.segment = new ClusterLabeledImage(connectRule);
    }

    public void process(T image, GrayS32 output) {
        InputSanityCheck.checkSameShape(image, (ImageBase)output);
        this.stopRequested = false;
        this.search.process(image);
        if (this.stopRequested) {
            return;
        }
        DogArray<float[]> regionColor = this.search.getModeColor();
        GrayS32 pixelToRegion = this.search.getPixelToRegion();
        DogArray_I32 regionPixelCount = this.search.getRegionMemberCount();
        DogArray<Point2D_I32> modeLocation = this.search.getModeLocation();
        this.merge.process(pixelToRegion, regionPixelCount, regionColor, modeLocation);
        if (this.stopRequested) {
            return;
        }
        this.segment.process(pixelToRegion, output, regionPixelCount);
        if (this.stopRequested) {
            return;
        }
        if (this.prune != null) {
            this.prune.process(image, output, regionPixelCount, regionColor);
        }
    }

    public int getNumberOfRegions() {
        return this.search.getRegionMemberCount().size;
    }

    public DogArray<float[]> getRegionColor() {
        return this.search.getModeColor();
    }

    public DogArray_I32 getRegionSize() {
        return this.search.getRegionMemberCount();
    }

    public ImageType<T> getImageType() {
        return this.search.getImageType();
    }

    public void requestStop() {
        this.stopRequested = true;
        this.search.requestStop();
        this.merge.requestStop();
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }
}

