/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.convert.ConvertTupleDesc;
import boofcv.abst.feature.describe.DescribePoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class DescribePointConvertTuple<T extends ImageGray<T>, In extends TupleDesc<In>, Out extends TupleDesc<Out>>
implements DescribePoint<T, Out> {
    DescribePoint<T, In> original;
    ConvertTupleDesc<In, Out> converter;
    In storage;

    public DescribePointConvertTuple(DescribePoint<T, In> original, ConvertTupleDesc<In, Out> converter) {
        this.original = original;
        this.converter = converter;
        this.storage = original.createDescription();
    }

    @Override
    public void setImage(T image) {
        this.original.setImage(image);
    }

    @Override
    public boolean process(double x, double y, Out description) {
        if (!this.original.process(x, y, this.storage)) {
            return false;
        }
        this.converter.convert(this.storage, description);
        return true;
    }

    @Override
    public Out createDescription() {
        return this.converter.createOutput();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.original.getImageType();
    }

    @Override
    public Class<Out> getDescriptionType() {
        return this.converter.getOutputType();
    }
}

