/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class FastToInterestPoint<T extends ImageGray<T>>
implements InterestPointDetector<T> {
    FastCornerDetector<T> detector;
    private final DogArray<Point2D_F64> found = new DogArray(Point2D_F64::new);
    private int totalLow;
    protected FeatureSelectLimit<Point2D_I16> selectLimit;
    protected FastArray<Point2D_I16> selected = new FastArray(Point2D_I16.class);
    public int featureLimitPerSet = Integer.MAX_VALUE;
    QueueCorner candidates = new QueueCorner();

    public FastToInterestPoint(FastCornerDetector<T> detector, FeatureSelectLimit<Point2D_I16> selectLimit) {
        this.detector = detector;
        this.selectLimit = selectLimit;
    }

    @Override
    public void detect(T input) {
        Point2D_I16 c;
        int i;
        this.detector.process(input);
        this.candidates.reset();
        this.detector.getCandidatesLow().copyInto((DogArray)this.candidates);
        this.selectLimit.select(((ImageGray)input).width, ((ImageGray)input).height, null, (FastAccess<Point2D_I16>)this.candidates, this.featureLimitPerSet, this.selected);
        this.totalLow = this.selected.size;
        this.found.resize(this.totalLow);
        for (i = 0; i < this.selected.size; ++i) {
            c = (Point2D_I16)this.selected.get(i);
            ((Point2D_F64)this.found.get(i)).setTo((double)c.x, (double)c.y);
        }
        this.candidates.reset();
        this.detector.getCandidatesHigh().copyInto((DogArray)this.candidates);
        this.selectLimit.select(((ImageGray)input).width, ((ImageGray)input).height, null, (FastAccess<Point2D_I16>)this.candidates, this.featureLimitPerSet, this.selected);
        this.found.reserve(this.found.size + this.selected.size);
        this.found.size += this.selected.size;
        for (i = 0; i < this.selected.size; ++i) {
            c = (Point2D_I16)this.selected.get(i);
            ((Point2D_F64)this.found.get(i + this.totalLow)).setTo((double)c.x, (double)c.y);
        }
    }

    @Override
    public int getSet(int index) {
        return index < this.totalLow ? 0 : 1;
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.detector.getImageType());
    }

    @Override
    public int getNumberOfSets() {
        return 2;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.found.size;
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return (Point2D_F64)this.found.get(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return 1.0;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    public FastCornerDetector<T> getDetector() {
        return this.detector;
    }

    public FeatureSelectLimit<Point2D_I16> getSelectLimit() {
        return this.selectLimit;
    }

    public int getFeatureLimitPerSet() {
        return this.featureLimitPerSet;
    }

    public void setFeatureLimitPerSet(int featureLimitPerSet) {
        this.featureLimitPerSet = featureLimitPerSet;
    }
}

