/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.flow;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.alg.flow.DenseOpticalFlowKlt;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ImagePyramid;
import java.lang.reflect.Array;

public class FlowKlt_to_DenseOpticalFlow<I extends ImageGray<I>, D extends ImageGray<D>>
implements DenseOpticalFlow<I> {
    DenseOpticalFlowKlt<I, D> flowKlt;
    ImageGradient<I, D> gradient;
    ImagePyramid<I> pyramidSrc;
    ImagePyramid<I> pyramidDst;
    Class<D> derivType;
    D[] srcDerivX;
    D[] srcDerivY;
    ImageType<I> imageType;

    public FlowKlt_to_DenseOpticalFlow(DenseOpticalFlowKlt<I, D> flowKlt, ImageGradient<I, D> gradient, ImagePyramid<I> pyramidSrc, ImagePyramid<I> pyramidDst, Class<I> inputType, Class<D> derivType) {
        this.flowKlt = flowKlt;
        this.gradient = gradient;
        this.pyramidSrc = pyramidSrc;
        this.pyramidDst = pyramidDst;
        this.derivType = derivType;
        this.imageType = ImageType.single(inputType);
    }

    @Override
    public void process(I source, I destination, ImageFlow flow) {
        this.pyramidSrc.process(source);
        this.pyramidDst.process(destination);
        if (this.pyramidSrc.getNumLayers() != this.pyramidDst.getNumLayers()) {
            throw new IllegalArgumentException("Pyramids do not have the same number of layers!");
        }
        if (this.srcDerivX == null || this.srcDerivX.length != this.pyramidSrc.getNumLayers()) {
            this.srcDerivX = (ImageGray[])Array.newInstance(this.derivType, this.pyramidSrc.getNumLayers());
            this.srcDerivY = (ImageGray[])Array.newInstance(this.derivType, this.pyramidSrc.getNumLayers());
            for (int i = 0; i < this.srcDerivX.length; ++i) {
                this.srcDerivX[i] = GeneralizedImageOps.createSingleBand(this.derivType, (int)1, (int)1);
                this.srcDerivY[i] = GeneralizedImageOps.createSingleBand(this.derivType, (int)1, (int)1);
            }
        }
        PyramidOps.reshapeOutput(this.pyramidSrc, this.srcDerivX);
        PyramidOps.reshapeOutput(this.pyramidSrc, this.srcDerivY);
        PyramidOps.gradient(this.pyramidSrc, this.gradient, this.srcDerivX, this.srcDerivY);
        this.flowKlt.process((ImagePyramid)this.pyramidSrc, (ImageGray[])this.srcDerivX, (ImageGray[])this.srcDerivY, (ImagePyramid)this.pyramidDst, flow);
    }

    @Override
    public ImageType<I> getInputType() {
        return this.imageType;
    }
}

