/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import pabeles.concurrency.GrowArray;

public class BackgroundStationaryBasic_PL_MT<T extends ImageGray<T>>
extends BackgroundStationaryBasic<Planar<T>> {
    protected Planar<GrayF32> background;
    protected GImageMultiBand inputWrapper;
    GrowArray<float[]> storagePixels;

    public BackgroundStationaryBasic_PL_MT(float learnRate, float threshold, ImageType<Planar<T>> imageType) {
        super(learnRate, threshold, imageType);
        int numBands = imageType.getNumBands();
        this.background = new Planar(GrayF32.class, 0, 0, numBands);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.storagePixels = new GrowArray(() -> new float[numBands]);
    }

    public Planar<GrayF32> getBackground() {
        return this.background;
    }

    @Override
    public void reset() {
        this.background.reshape(0, 0);
    }

    @Override
    public void updateBackground(Planar<T> frame) {
        if (this.background.width != frame.width || this.background.height != frame.height) {
            this.background.reshape(frame.width, frame.height);
            GConvertImage.convert(frame, this.background);
            return;
        }
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands();
        float minusLearn = 1.0f - this.learnRate;
        BoofConcurrency.loopBlocks((int)0, (int)frame.height, (int)20, this.storagePixels, (inputPixels, idx0, idx1) -> {
            for (int y = idx0; y < idx1; ++y) {
                int indexBG = y * frame.width;
                int indexInput = frame.startIndex + y * frame.stride;
                int end = indexInput + frame.width;
                while (indexInput < end) {
                    this.inputWrapper.getF(indexInput, inputPixels);
                    for (int band = 0; band < numBands; ++band) {
                        GrayF32 backgroundBand = (GrayF32)this.background.getBand(band);
                        backgroundBand.data[indexBG] = minusLearn * backgroundBand.data[indexBG] + this.learnRate * inputPixels[band];
                    }
                    ++indexInput;
                    ++indexBG;
                }
            }
        });
    }

    @Override
    public void segment(Planar<T> frame, GrayU8 segmented) {
        segmented.reshape(frame.width, frame.height);
        if (this.background.width != frame.width || this.background.height != frame.height) {
            ImageMiscOps.fill((GrayI8)segmented, (int)this.unknownValue);
            return;
        }
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands();
        float thresholdSq = (float)numBands * this.threshold * this.threshold;
        BoofConcurrency.loopBlocks((int)0, (int)frame.height, (int)20, this.storagePixels, (inputPixels, idx0, idx1) -> {
            for (int y = idx0; y < idx1; ++y) {
                int indexBG = y * frame.width;
                int indexInput = frame.startIndex + y * frame.stride;
                int indexSegmented = segmented.startIndex + y * segmented.stride;
                int end = indexInput + frame.width;
                while (indexInput < end) {
                    this.inputWrapper.getF(indexInput, inputPixels);
                    double sumErrorSq = 0.0;
                    for (int band = 0; band < numBands; ++band) {
                        float diff = ((GrayF32)this.background.getBand((int)band)).data[indexBG] - inputPixels[band];
                        sumErrorSq += (double)(diff * diff);
                    }
                    segmented.data[indexSegmented++] = (byte)(!(sumErrorSq <= (double)thresholdSq) ? 1 : 0);
                    ++indexInput;
                    ++indexBG;
                }
            }
        });
    }
}

