/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import pabeles.concurrency.GrowArray;

public class BackgroundStationaryGaussian_IL_MT<T extends ImageInterleaved<T>>
extends BackgroundStationaryGaussian<T> {
    protected GImageMultiBand inputWrapper;
    protected GImageMultiBand bgWrapper;
    Work work;
    GrowArray<Work> workspace;
    InterleavedF32 background;

    public BackgroundStationaryGaussian_IL_MT(float learnRate, float threshold, ImageType<T> imageType) {
        super(learnRate, threshold, imageType);
        int numBands = imageType.getNumBands();
        this.background = new InterleavedF32(0, 0, 2 * numBands);
        this.bgWrapper = FactoryGImageMultiBand.create((ImageType)this.background.getImageType());
        this.bgWrapper.wrap((ImageBase)this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.workspace = new GrowArray(() -> new Work(numBands));
        this.work = (Work)this.workspace.grow();
    }

    @Override
    public void reset() {
        this.background.reshape(0, 0);
    }

    @Override
    public void updateBackground(T frame) {
        this.inputWrapper.wrap(frame);
        if (this.background.width != ((ImageInterleaved)frame).width || this.background.height != ((ImageInterleaved)frame).height) {
            this.background.reshape(((ImageInterleaved)frame).width, ((ImageInterleaved)frame).height);
            BoofConcurrency.loopBlocks((int)0, (int)((ImageInterleaved)frame).height, (int)20, this.workspace, (work, idx0, idx1) -> {
                float[] inputPixel = work.inputPixel;
                float[] bgPixel = work.bgPixel;
                for (int y = idx0; y < idx1; ++y) {
                    for (int x = 0; x < frame.width; ++x) {
                        this.inputWrapper.get(x, y, inputPixel);
                        for (int i = 0; i < frame.numBands; ++i) {
                            bgPixel[i * 2] = inputPixel[i];
                            bgPixel[i * 2 + 1] = this.initialVariance;
                        }
                        this.bgWrapper.set(x, y, bgPixel);
                    }
                }
            });
            return;
        }
        InputSanityCheck.checkSameShape((ImageBase)this.background, frame);
        int numBands = this.background.getNumBands() / 2;
        float minusLearn = 1.0f - this.learnRate;
        BoofConcurrency.loopBlocks((int)0, (int)((ImageInterleaved)frame).height, (int)20, this.workspace, (work, idx0, idx1) -> {
            float[] inputPixel = work.inputPixel;
            for (int y = idx0; y < idx1; ++y) {
                int indexInput;
                int indexBG = y * this.background.stride;
                int end = indexInput + frame.width * numBands;
                for (indexInput = frame.startIndex + y * frame.stride; indexInput < end; indexInput += frame.numBands) {
                    this.inputWrapper.getF(indexInput, inputPixel);
                    for (int band = 0; band < numBands; ++band) {
                        float inputValue = inputPixel[band];
                        float meanBG = this.background.data[indexBG];
                        float varianceBG = this.background.data[indexBG + 1];
                        float diff = meanBG - inputValue;
                        this.background.data[indexBG++] = minusLearn * meanBG + this.learnRate * inputValue;
                        this.background.data[indexBG++] = minusLearn * varianceBG + this.learnRate * diff * diff;
                    }
                }
            }
        });
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        segmented.reshape(((ImageInterleaved)frame).width, ((ImageInterleaved)frame).height);
        if (this.background.width != ((ImageInterleaved)frame).width || this.background.height != ((ImageInterleaved)frame).height) {
            ImageMiscOps.fill((GrayI8)segmented, (int)this.unknownValue);
            return;
        }
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands() / 2;
        float adjustedMinimumDifference = this.minimumDifference * (float)numBands;
        BoofConcurrency.loopBlocks((int)0, (int)((ImageInterleaved)frame).height, (int)20, this.workspace, (work, idx0, idx1) -> {
            float[] inputPixel = work.inputPixel;
            for (int y = idx0; y < idx1; ++y) {
                int indexBG = y * this.background.stride;
                int indexInput = frame.startIndex + y * frame.stride;
                int indexSegmented = segmented.startIndex + y * segmented.stride;
                int end = indexInput + frame.width * frame.numBands;
                while (indexInput < end) {
                    this.inputWrapper.getF(indexInput, inputPixel);
                    float mahalanobis = 0.0f;
                    for (int band = 0; band < numBands; ++band) {
                        int indexBG_band = indexBG + band * 2;
                        float meanBG = this.background.data[indexBG_band];
                        float varBG = this.background.data[indexBG_band + 1];
                        float diff = meanBG - inputPixel[band];
                        mahalanobis += diff * diff / varBG;
                    }
                    if (mahalanobis <= this.threshold) {
                        segmented.data[indexSegmented] = 0;
                    } else if (this.minimumDifference == 0.0f) {
                        segmented.data[indexSegmented] = 1;
                    } else {
                        float sumAbsDiff = 0.0f;
                        for (int band = 0; band < numBands; ++band) {
                            int indexBG_band = indexBG + band * 2;
                            sumAbsDiff += Math.abs(this.background.data[indexBG_band] - inputPixel[band]);
                        }
                        segmented.data[indexSegmented] = sumAbsDiff >= adjustedMinimumDifference ? (byte)1 : (byte)0;
                    }
                    indexInput += frame.numBands;
                    ++indexSegmented;
                    indexBG += this.background.numBands;
                }
            }
        });
    }

    private static class Work {
        final float[] inputPixel;
        final float[] bgPixel;

        public Work(int numBands) {
            this.inputPixel = new float[numBands];
            this.bgPixel = new float[numBands * 2];
        }
    }
}

