/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.descriptor;

import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;

public class ConvertDescriptors {
    public static void positive(TupleDesc_F64 input, TupleDesc_U8 output) {
        int i;
        double max = 0.0;
        for (i = 0; i < input.size(); ++i) {
            double v = input.data[i];
            if (!(v > max)) continue;
            max = v;
        }
        if (max == 0.0) {
            max = 1.0;
        }
        for (i = 0; i < input.size(); ++i) {
            output.data[i] = (byte)(255.0 * input.data[i] / max);
        }
    }

    public static void signed(TupleDesc_F64 input, TupleDesc_S8 output) {
        int i;
        double max = 0.0;
        for (i = 0; i < input.size(); ++i) {
            double v = Math.abs(input.data[i]);
            if (!(v > max)) continue;
            max = v;
        }
        for (i = 0; i < input.size(); ++i) {
            output.data[i] = (byte)(127.0 * input.data[i] / max);
        }
    }

    public static void float_F64_F32(TupleDesc_F64 input, TupleDesc_F32 output) {
        for (int i = 0; i < input.size(); ++i) {
            output.data[i] = (float)input.data[i];
        }
    }

    public static void convertNcc(TupleDesc_F64 input, NccFeature output) {
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("Feature lengths do not match.");
        }
        double mean = 0.0;
        for (int i = 0; i < input.data.length; ++i) {
            mean += input.data[i];
        }
        mean /= (double)input.data.length;
        double variance = 0.0;
        for (int i = 0; i < input.data.length; ++i) {
            double d = output.data[i] = input.data[i] - mean;
            variance += d * d;
        }
        output.mean = mean;
        output.sigma = Math.sqrt(variance /= (double)output.size());
    }
}

