/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.descriptor;

import boofcv.abst.feature.associate.AssociateDescriptionArraySets;
import boofcv.abst.feature.associate.AssociateDescriptionSets2D;
import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;

public class UtilFeature {
    public static <TD extends TupleDesc<TD>> DogArray<TD> createArray(DescriptorInfo<TD> detDesc, int initialMax) {
        DogArray ret = new DogArray(detDesc::createDescription);
        ret.reserve(initialMax);
        return ret;
    }

    public static DogArray<TupleDesc_F64> createArrayF64(int length) {
        return new DogArray(() -> new TupleDesc_F64(length));
    }

    public static TupleDesc_F64 combine(List<TupleDesc_F64> inputs, TupleDesc_F64 combined) {
        int N = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            N += inputs.get(i).size();
        }
        if (combined == null) {
            combined = new TupleDesc_F64(N);
        } else if (N != combined.size()) {
            throw new RuntimeException("The combined feature needs to be " + N + "  not " + combined.size());
        }
        int start = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            double[] v = inputs.get((int)i).data;
            System.arraycopy(v, 0, combined.data, start, v.length);
            start += v.length;
        }
        return combined;
    }

    public static void normalizeL2(TupleDesc_F64 desc) {
        int i;
        double norm = 0.0;
        for (i = 0; i < desc.size(); ++i) {
            double v = desc.data[i];
            norm += v * v;
        }
        if (norm == 0.0) {
            return;
        }
        norm = Math.sqrt(norm);
        i = 0;
        while (i < desc.size()) {
            int n = i++;
            desc.data[n] = desc.data[n] / norm;
        }
    }

    public static void normalizeSumOne(TupleDesc_F64 desc) {
        int i;
        double sum = 0.0;
        for (i = 0; i < desc.size(); ++i) {
            double v = desc.data[i];
            sum += v;
        }
        if (sum == 0.0) {
            return;
        }
        i = 0;
        while (i < desc.size()) {
            int n = i++;
            desc.data[n] = desc.data[n] / sum;
        }
    }

    public static <TD extends TupleDesc<TD>> void setSource(FastAccess<TD> descriptors, DogArray_I32 sets, AssociateDescriptionArraySets<TD> association) {
        assert (descriptors.size == sets.size);
        association.clearSource();
        int N = descriptors.size;
        for (int i = 0; i < N; ++i) {
            association.addSource(((TupleDesc[])descriptors.data)[i], sets.data[i]);
        }
    }

    public static <TD extends TupleDesc<TD>> void setDestination(FastAccess<TD> descriptors, DogArray_I32 sets, AssociateDescriptionArraySets<TD> association) {
        assert (descriptors.size == sets.size);
        association.clearDestination();
        int N = descriptors.size;
        for (int i = 0; i < N; ++i) {
            association.addDestination(((TupleDesc[])descriptors.data)[i], sets.data[i]);
        }
    }

    public static <TD extends TupleDesc<TD>> void setSource(FastAccess<TD> descriptors, DogArray_I32 sets, FastAccess<Point2D_F64> locs, AssociateDescriptionSets2D<TD> association) {
        assert (descriptors.size == sets.size);
        assert (descriptors.size == locs.size);
        association.clearSource();
        int N = descriptors.size;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 l = ((Point2D_F64[])locs.data)[i];
            association.addSource(((TupleDesc[])descriptors.data)[i], l.x, l.y, sets.data[i]);
        }
    }

    public static <TD extends TupleDesc<TD>> void setDestination(FastAccess<TD> descriptors, DogArray_I32 sets, FastAccess<Point2D_F64> locs, AssociateDescriptionSets2D<TD> association) {
        assert (descriptors.size == sets.size);
        assert (descriptors.size == locs.size);
        association.clearDestination();
        int N = descriptors.size;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 l = ((Point2D_F64[])locs.data)[i];
            association.addDestination(((TupleDesc[])descriptors.data)[i], l.x, l.y, sets.data[i]);
        }
    }
}

