/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.misc.BoofMiscOps;
import java.util.Random;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class FeatureSelectRandom<Point>
implements FeatureSelectLimit<Point> {
    final Random rand;
    private final DogArray_I32 indexes = new DogArray_I32();

    public FeatureSelectRandom(long seed) {
        this.rand = new Random(seed);
    }

    @Override
    public void select(int imageWidth, int imageHeight, @Nullable FastAccess<Point> prior, FastAccess<Point> detected, int limit, FastArray<Point> selected) {
        int i;
        BoofMiscOps.checkTrue((limit > 0 ? 1 : 0) != 0);
        selected.reset();
        if (detected.size <= limit) {
            selected.addAll(detected);
            return;
        }
        this.indexes.resize(detected.size);
        for (i = 0; i < detected.size; ++i) {
            this.indexes.data[i] = i;
        }
        selected.resize(limit);
        for (i = 0; i < limit; ++i) {
            int idx = this.rand.nextInt(this.indexes.size - i);
            selected.set(i, detected.data[this.indexes.data[idx]]);
            this.indexes.data[idx] = this.indexes.data[this.indexes.size - i - 1];
        }
    }
}

