/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detdesc;

import boofcv.abst.feature.convert.ConvertTupleDesc;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.feature.detdesc.CompleteSift_DetectDescribe;
import boofcv.abst.feature.detdesc.ConfigCompleteSift;
import boofcv.abst.feature.detdesc.DetectDescribeConvertTuple;
import boofcv.abst.feature.detdesc.DetectDescribeFusion;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detdesc.SurfPlanar_to_DetectDescribe;
import boofcv.abst.feature.detdesc.Surf_DetectDescribe;
import boofcv.abst.feature.detdesc.Surf_DetectDescribe_MT;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.feature.detdesc.CompleteSift;
import boofcv.alg.feature.detdesc.DetectDescribeSurfPlanar;
import boofcv.alg.feature.detdesc.DetectDescribeSurfPlanar_MT;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.describe.ConfigConvertTupleDesc;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.describe.FactoryConvertTupleDesc;
import boofcv.factory.feature.describe.FactoryDescribeAlgs;
import boofcv.factory.feature.describe.FactoryDescribePointRadiusAngle;
import boofcv.factory.feature.detdesc.ConfigDetectDescribe;
import boofcv.factory.feature.detdesc.FactoryDetectDescribeAlgs;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import org.jetbrains.annotations.Nullable;

public class FactoryDetectDescribe {
    public static <Image extends ImageGray<Image>, Desc extends TupleDesc<Desc>> DetectDescribePoint<Image, Desc> generic(ConfigDetectDescribe config, Class<Image> imageType) {
        DescribePointRadiusAngle<Object, TupleDesc<TupleDesc_F64>> describePointRadiusAngle;
        InterestPointDetector<Image> detector;
        DetectDescribePoint<Image, TupleDesc_F64> detDesc = null;
        if (config.typeDetector == ConfigDetectInterestPoint.Type.FAST_HESSIAN) {
            switch (config.typeDescribe) {
                case SURF_FAST: {
                    detDesc = FactoryDetectDescribe.surfFast(config.detectFastHessian, config.describeSurfFast, config.orientation.averageIntegral, imageType);
                    break;
                }
                case SURF_STABLE: {
                    detDesc = FactoryDetectDescribe.surfStable(config.detectFastHessian, config.describeSurfStability, config.orientation.slidingIntegral, imageType);
                }
            }
        } else if (config.typeDescribe == ConfigDescribeRegion.Type.SIFT) {
            ConfigCompleteSift configSift = new ConfigCompleteSift();
            configSift.scaleSpace = config.scaleSpaceSift;
            configSift.detector = config.detectSift;
            configSift.describe = config.describeSift;
            detDesc = FactoryDetectDescribe.sift(configSift, imageType);
        }
        if (detDesc != null) {
            return FactoryDetectDescribe.convertDesc(config.convertDescriptor, detDesc);
        }
        switch (config.typeDetector) {
            case FAST_HESSIAN: {
                detector = FactoryInterestPoint.fastHessian(config.detectFastHessian, imageType);
                break;
            }
            case SIFT: {
                detector = FactoryInterestPoint.sift(config.scaleSpaceSift, config.detectSift, imageType);
                break;
            }
            case POINT: {
                GeneralFeatureDetector alg = FactoryDetectPoint.create(config.detectPoint, imageType, null);
                detector = FactoryInterestPoint.wrapPoint(alg, config.detectPoint.scaleRadius, imageType, alg.getDerivType());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown detector");
            }
        }
        switch (config.typeDescribe) {
            case SURF_FAST: {
                describePointRadiusAngle = FactoryDescribePointRadiusAngle.surfFast(config.describeSurfFast, imageType);
                break;
            }
            case SURF_COLOR_FAST: {
                describePointRadiusAngle = FactoryDescribePointRadiusAngle.surfColorFast(config.describeSurfFast, ImageType.pl((int)3, imageType));
                break;
            }
            case SURF_STABLE: {
                describePointRadiusAngle = FactoryDescribePointRadiusAngle.surfStable(config.describeSurfStability, imageType);
                break;
            }
            case SURF_COLOR_STABLE: {
                describePointRadiusAngle = FactoryDescribePointRadiusAngle.surfColorStable(config.describeSurfStability, ImageType.pl((int)3, imageType));
                break;
            }
            case SIFT: {
                describePointRadiusAngle = FactoryDescribePointRadiusAngle.sift(config.scaleSpaceSift, config.describeSift, imageType);
                break;
            }
            case BRIEF: {
                describePointRadiusAngle = FactoryDescribePointRadiusAngle.brief(config.describeBrief, imageType);
                break;
            }
            case TEMPLATE: {
                describePointRadiusAngle = FactoryDescribePointRadiusAngle.template(config.describeTemplate, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown descriptor: " + config.typeDescribe);
            }
        }
        DescribePointRadiusAngle<Image, TupleDesc<TupleDesc_F64>> descriptor = describePointRadiusAngle;
        OrientationImage<Image> orientation = null;
        if (descriptor.isOriented()) {
            Class integralType = GIntegralImageOps.getIntegralType(imageType);
            OrientationIntegral orientationII = FactoryOrientation.genericIntegral(config.orientation, integralType);
            orientation = FactoryOrientation.convertImage(orientationII, imageType);
        }
        return FactoryDetectDescribe.convertDesc(config.convertDescriptor, FactoryDetectDescribe.fuseTogether(detector, orientation, descriptor));
    }

    private static <T extends ImageGray<T>, In extends TupleDesc<In>, Out extends TupleDesc<Out>> DetectDescribePoint<T, Out> convertDesc(ConfigConvertTupleDesc config, DetectDescribePoint<T, In> original) {
        if (config.outputData == ConfigConvertTupleDesc.DataType.NATIVE) {
            return original;
        }
        int dof = original.createDescription().size();
        ConvertTupleDesc converter = FactoryConvertTupleDesc.generic(config, dof, original.getDescriptionType());
        return new DetectDescribeConvertTuple(original, converter);
    }

    public static <T extends ImageGray<T>> DetectDescribePoint<T, TupleDesc_F64> sift(@Nullable ConfigCompleteSift config, Class<T> imageType) {
        CompleteSift dds = FactoryDetectDescribeAlgs.sift(config);
        return new CompleteSift_DetectDescribe<T>(dds, imageType);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DetectDescribePoint<T, TupleDesc_F64> surfFast(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Fast configDesc, @Nullable ConfigAverageIntegral configOrientation, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurf describe = FactoryDescribeAlgs.surfSpeed(configDesc, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.average_ii(configOrientation, integralType);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new Surf_DetectDescribe_MT(detector, orientation, describe, imageType);
        }
        return new Surf_DetectDescribe(detector, orientation, describe, imageType);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DetectDescribePoint<T, TupleDesc_F64> surfColorFast(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Fast configDesc, @Nullable ConfigAverageIntegral configOrientation, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurf describe = FactoryDescribeAlgs.surfSpeed(configDesc, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.average_ii(configOrientation, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar describeMulti = new DescribePointSurfPlanar(describe, imageType.getNumBands());
            DetectDescribeSurfPlanar detectDesc = FactoryDetectDescribe.createDescribeSurfPlanar(detector, orientation, describeMulti);
            return new SurfPlanar_to_DetectDescribe(detectDesc, bandType, integralType);
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    protected static <II extends ImageGray<II>> DetectDescribeSurfPlanar<II> createDescribeSurfPlanar(FastHessianFeatureDetector<II> detector, OrientationIntegral<II> orientation, DescribePointSurfPlanar<II> describeMulti) {
        DetectDescribeSurfPlanar detectDesc = BoofConcurrency.USE_CONCURRENT ? new DetectDescribeSurfPlanar_MT<II>(detector, orientation, describeMulti) : new DetectDescribeSurfPlanar<II>(detector, orientation, describeMulti);
        return detectDesc;
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DetectDescribePoint<T, TupleDesc_F64> surfStable(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Stability configDescribe, @Nullable ConfigSlidingIntegral configOrientation, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurfMod describe = FactoryDescribeAlgs.surfStability(configDescribe, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new Surf_DetectDescribe_MT(detector, orientation, describe, imageType);
        }
        return new Surf_DetectDescribe(detector, orientation, describe, imageType);
    }

    public static <T extends ImageMultiBand<T>, II extends ImageGray<II>> DetectDescribePoint<T, TupleDesc_F64> surfColorStable(@Nullable ConfigFastHessian configDetector, @Nullable ConfigSurfDescribe.Stability configDescribe, @Nullable ConfigSlidingIntegral configOrientation, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurfMod describe = FactoryDescribeAlgs.surfStability(configDescribe, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            DescribePointSurfPlanar describeMulti = new DescribePointSurfPlanar(describe, imageType.getNumBands());
            DetectDescribeSurfPlanar detectDesc = FactoryDetectDescribe.createDescribeSurfPlanar(detector, orientation, describeMulti);
            return new SurfPlanar_to_DetectDescribe(detectDesc, bandType, integralType);
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    public static <T extends ImageGray<T>, TD extends TupleDesc<TD>> DetectDescribePoint<T, TD> fuseTogether(InterestPointDetector<T> detector, @Nullable OrientationImage<T> orientation, DescribePointRadiusAngle<T, TD> describe) {
        return new DetectDescribeFusion<T, TD>(detector, orientation, describe);
    }
}

