/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.cloud;

import boofcv.alg.cloud.AccessColorIndex;
import boofcv.alg.cloud.AccessPointIndex;
import boofcv.misc.BoofLambdas;
import boofcv.struct.Point3dRgbI_F32;
import georegression.helper.KdTreePoint3D_F32;
import georegression.struct.point.Point3D_F32;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class PointCloudUtils_F32 {
    public static DogArray<Point3dRgbI_F32> filter(AccessPointIndex<Point3D_F32> accessPoint, AccessColorIndex accessColor, int size, BoofLambdas.FilterInt filter, @Nullable DogArray<Point3dRgbI_F32> output) {
        if (output == null) {
            output = new DogArray(Point3dRgbI_F32::new);
        }
        output.reset();
        output.reserve(size / 5);
        Point3dRgbI_F32 p = (Point3dRgbI_F32)output.grow();
        for (int pointIdx = 0; pointIdx < size; ++pointIdx) {
            if (!filter.keep(pointIdx)) continue;
            accessPoint.getPoint(pointIdx, (Point3D_F32)p);
            p.rgb = accessColor.getRGB(pointIdx);
            p = (Point3dRgbI_F32)output.grow();
        }
        output.removeTail();
        return output;
    }

    public static float autoScale(List<Point3D_F32> cloud, float target) {
        Point3D_F32 mean = new Point3D_F32();
        Point3D_F32 stdev = new Point3D_F32();
        PointCloudUtils_F32.statistics(cloud, mean, stdev);
        float scale = target / Math.max(Math.max(stdev.x, stdev.y), stdev.z);
        int N = cloud.size();
        for (int i = 0; i < N; ++i) {
            cloud.get(i).scale(scale);
        }
        return scale;
    }

    public static void statistics(List<Point3D_F32> cloud, Point3D_F32 mean, Point3D_F32 stdev) {
        Point3D_F32 p;
        int i;
        int N = cloud.size();
        for (i = 0; i < N; ++i) {
            p = cloud.get(i);
            mean.x += p.x / (float)N;
            mean.y += p.y / (float)N;
            mean.z += p.z / (float)N;
        }
        for (i = 0; i < N; ++i) {
            p = cloud.get(i);
            float dx = p.x - mean.x;
            float dy = p.y - mean.y;
            float dz = p.z - mean.z;
            stdev.x += dx * dx / (float)N;
            stdev.y += dy * dy / (float)N;
            stdev.z += dz * dz / (float)N;
        }
        stdev.x = (float)Math.sqrt(stdev.x);
        stdev.y = (float)Math.sqrt(stdev.y);
        stdev.z = (float)Math.sqrt(stdev.z);
    }

    public static void prune(List<Point3D_F32> cloud, int minNeighbors, float radius) {
        if (minNeighbors < 0) {
            throw new IllegalArgumentException("minNeighbors must be >= 0");
        }
        NearestNeighbor nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new KdTreePoint3D_F32());
        NearestNeighbor.Search search = nn.createSearch();
        nn.setPoints(cloud, false);
        DogArray results = new DogArray(NnData::new);
        ++minNeighbors;
        radius *= radius;
        for (int i = cloud.size() - 1; i >= 0; --i) {
            search.findNearest((Object)cloud.get(i), (double)radius, minNeighbors, results);
            if (results.size >= minNeighbors) continue;
            cloud.remove(i);
        }
    }

    public static void prune(List<Point3D_F32> cloud, DogArray_I32 colors, int minNeighbors, float radius) {
        if (minNeighbors < 0) {
            throw new IllegalArgumentException("minNeighbors must be >= 0");
        }
        NearestNeighbor nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new KdTreePoint3D_F32());
        NearestNeighbor.Search search = nn.createSearch();
        nn.setPoints(cloud, false);
        DogArray results = new DogArray(NnData::new);
        ++minNeighbors;
        radius *= radius;
        for (int i = cloud.size() - 1; i >= 0; --i) {
            search.findNearest((Object)cloud.get(i), (double)radius, minNeighbors, results);
            if (results.size >= minNeighbors) continue;
            cloud.remove(i);
            colors.remove(i);
        }
    }
}

