/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.kanbra;

public class KannalaBrandtUtils_F32 {
    public static float polynomial(float[] coefs, float x) {
        float pow = x;
        float result = 0.0f;
        for (int i = 0; i < coefs.length; ++i) {
            result += coefs[i] * pow;
            pow *= x * x;
        }
        return result;
    }

    public static float polytrig(float[] coefs, float cos, float sin) {
        if (coefs.length == 0) {
            return 0.0f;
        }
        float result = 0.0f;
        result += coefs[0] * cos;
        result += coefs[1] * sin;
        result += coefs[2] * 2.0f * cos * sin;
        return result += coefs[3] * (2.0f * cos * cos - 1.0f);
    }

    public static void polytrigGradient(float cos, float sin, float[] gradient) {
        gradient[0] = cos;
        gradient[1] = sin;
        gradient[2] = 2.0f * cos * sin;
        gradient[3] = 2.0f * cos * cos - 1.0f;
    }

    public static float polynomialDerivative(float[] coefs, float x) {
        float pow = 1.0f;
        float left = 1.0f;
        float result = 0.0f;
        for (int i = 0; i < coefs.length; ++i) {
            result += left * coefs[i] * pow;
            pow *= x * x;
            left += 2.0f;
        }
        return result;
    }

    public static float polytrigDerivative(float[] coefs, float cos, float sin) {
        if (coefs.length == 0) {
            return 0.0f;
        }
        float result = 0.0f;
        result -= coefs[0] * sin;
        result += coefs[1] * cos;
        result += 2.0f * coefs[2] * (cos * cos - sin * sin);
        return result -= 4.0f * coefs[3] * cos * sin;
    }
}

