/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.pinhole;

import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import georegression.struct.point.Point2D_F32;

public class PixelTransformPinholeNorm_F32
implements PixelTransform<Point2D_F32> {
    private float a11;
    private float a12;
    private float a13;
    private float a22;
    private float a23;

    public PixelTransformPinholeNorm_F32(PixelTransformPinholeNorm_F32 original) {
        this.a11 = original.a11;
        this.a12 = original.a12;
        this.a13 = original.a13;
        this.a22 = original.a22;
        this.a23 = original.a23;
    }

    public PixelTransformPinholeNorm_F32() {
    }

    public PixelTransformPinholeNorm_F32 fset(CameraPinhole pinhole) {
        return this.fset(pinhole.fx, pinhole.fy, pinhole.skew, pinhole.cx, pinhole.cy);
    }

    public PixelTransformPinholeNorm_F32 fset(double fx, double fy, double skew, double cx, double cy) {
        this.a11 = (float)(1.0 / fx);
        this.a12 = (float)(-skew / (fx * fy));
        this.a13 = (float)((skew * cy - cx * fy) / (fx * fy));
        this.a22 = (float)(1.0 / fy);
        this.a23 = (float)(-cy / fy);
        return this;
    }

    public void compute(int x, int y, Point2D_F32 out) {
        out.x = this.a11 * (float)x + this.a12 * (float)y + this.a13;
        out.y = this.a22 * (float)y + this.a23;
    }

    public PixelTransformPinholeNorm_F32 copyConcurrent() {
        return new PixelTransformPinholeNorm_F32(this);
    }
}

