/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.alg.distort.kanbra.KannalaBrandtUtils_F64;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraKannalaBrandt;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.point.Point2D_F64;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BundleKannalaBrandt
implements BundleAdjustmentCamera {
    public final CameraKannalaBrandt model = new CameraKannalaBrandt();
    public boolean zeroSkew;
    public boolean isAsymmetric;
    int dof;
    double polyRad;
    double polyRadTrig;
    double polyTan;
    double polyTanTrig;
    double[] polyTrigGradient = new double[4];

    public BundleKannalaBrandt(CameraKannalaBrandt model) {
        this.configure(model.skew == 0.0, model.symmetric.length, model.radial.length);
        this.model.setTo(model);
    }

    public BundleKannalaBrandt() {
    }

    public void configure(boolean zeroSkew, int numSymmetric, int numAsymmetric) {
        this.zeroSkew = zeroSkew;
        this.model.configureCoefficients(numSymmetric, numAsymmetric);
        this.dof = zeroSkew ? 4 : 5;
        this.dof += this.model.symmetric.length;
        this.dof += this.model.radial.length;
        this.dof += this.model.radialTrig.length;
        this.dof += this.model.tangent.length;
        this.dof += this.model.tangentTrig.length;
        this.isAsymmetric = numAsymmetric > 0;
    }

    @Override
    public void setIntrinsic(double[] parameters, int offset) {
        int index = offset;
        this.model.fx = parameters[index++];
        this.model.fy = parameters[index++];
        this.model.cx = parameters[index++];
        this.model.cy = parameters[index++];
        if (!this.zeroSkew) {
            this.model.skew = parameters[index++];
        }
        if (this.model.symmetric.length > 0) {
            System.arraycopy(parameters, index, this.model.symmetric, 0, this.model.symmetric.length);
            index += this.model.symmetric.length;
        }
        if (this.model.radial.length > 0) {
            System.arraycopy(parameters, index, this.model.radial, 0, this.model.radial.length);
            System.arraycopy(parameters, index += this.model.radial.length, this.model.radialTrig, 0, this.model.radialTrig.length);
            index += this.model.radialTrig.length;
        }
        if (this.model.tangent.length > 0) {
            System.arraycopy(parameters, index, this.model.tangent, 0, this.model.tangent.length);
            System.arraycopy(parameters, index += this.model.tangent.length, this.model.tangentTrig, 0, this.model.tangentTrig.length);
        }
    }

    @Override
    public void getIntrinsic(double[] parameters, int offset) {
        BoofMiscOps.checkTrue((parameters.length >= offset + this.dof ? 1 : 0) != 0);
        int index = offset;
        parameters[index++] = this.model.fx;
        parameters[index++] = this.model.fy;
        parameters[index++] = this.model.cx;
        parameters[index++] = this.model.cy;
        if (!this.zeroSkew) {
            parameters[index++] = this.model.skew;
        }
        if (this.model.symmetric.length > 0) {
            System.arraycopy(this.model.symmetric, 0, parameters, index, this.model.symmetric.length);
            index += this.model.symmetric.length;
        }
        if (this.model.radial.length > 0) {
            System.arraycopy(this.model.radial, 0, parameters, index, this.model.radial.length);
            System.arraycopy(this.model.radialTrig, 0, parameters, index += this.model.radial.length, this.model.radialTrig.length);
            index += this.model.radialTrig.length;
        }
        if (this.model.tangent.length > 0) {
            System.arraycopy(this.model.tangent, 0, parameters, index, this.model.tangent.length);
            System.arraycopy(this.model.tangentTrig, 0, parameters, index += this.model.tangent.length, this.model.tangentTrig.length);
        }
    }

    @Override
    public void project(double camX, double camY, double camZ, Point2D_F64 output) {
        double distY;
        double distX;
        double theta = Math.acos(camZ / UtilPoint3D_F64.norm((double)camX, (double)camY, (double)camZ));
        double r = KannalaBrandtUtils_F64.polynomial(this.model.symmetric, theta);
        double phi = Math.atan2(camY, camX);
        double cosphi = Math.cos(phi);
        double sinphi = Math.sin(phi);
        if (this.isAsymmetric) {
            double disRad = KannalaBrandtUtils_F64.polynomial(this.model.radial, theta) * KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi);
            double disTan = KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta) * KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi);
            distX = (r + disRad) * cosphi - disTan * sinphi;
            distY = (r + disRad) * sinphi + disTan * cosphi;
        } else {
            distX = r * cosphi;
            distY = r * sinphi;
        }
        double skew = this.zeroSkew ? 0.0 : this.model.skew;
        output.x = this.model.fx * distX + skew * distY + this.model.cx;
        output.y = this.model.fy * distY + this.model.cy;
    }

    @Override
    public void jacobian(double camX, double camY, double camZ, double[] pointX, double[] pointY, boolean computeIntrinsic, @Nullable double[] calibX, @Nullable double[] calibY) {
        double disTan_d;
        double disRad_d;
        int index;
        double norm2 = camX * camX + camY * camY + camZ * camZ;
        double norm = Math.sqrt(norm2);
        double norm3 = norm2 * norm;
        double acos_input = camZ / norm;
        double theta = Math.acos(acos_input);
        double r = KannalaBrandtUtils_F64.polynomial(this.model.symmetric, theta);
        double phi = Math.atan2(camY, camX);
        double cosphi = Math.cos(phi);
        double sinphi = Math.sin(phi);
        double theta_d = -1.0 / Math.sqrt(1.0 - acos_input * acos_input);
        double theta_dX = -theta_d * camZ * camX / norm3;
        double theta_dY = -theta_d * camZ * camY / norm3;
        double theta_dZ = theta_d * (1.0 / norm - camZ * camZ / norm3);
        double r_dTheta = KannalaBrandtUtils_F64.polynomialDerivative(this.model.symmetric, theta);
        double phi_dX = -camY / (camX * camX + camY * camY);
        double phi_dY = camX / (camX * camX + camY * camY);
        double distX_dX = r_dTheta * theta_dX * cosphi - r * sinphi * phi_dX;
        double distX_dY = r_dTheta * theta_dY * cosphi - r * sinphi * phi_dY;
        double distX_dZ = r_dTheta * theta_dZ * cosphi;
        double distY_dX = r_dTheta * theta_dX * sinphi + r * cosphi * phi_dX;
        double distY_dY = r_dTheta * theta_dY * sinphi + r * cosphi * phi_dY;
        double distY_dZ = r_dTheta * theta_dZ * sinphi;
        double distX = r * cosphi;
        double distY = r * sinphi;
        if (this.isAsymmetric) {
            double polyRad_dTheta = KannalaBrandtUtils_F64.polynomialDerivative(this.model.radial, theta);
            double polyRadTrig_dPhi = KannalaBrandtUtils_F64.polytrigDerivative(this.model.radialTrig, cosphi, sinphi);
            double polyTan_dTheta = KannalaBrandtUtils_F64.polynomialDerivative(this.model.tangent, theta);
            double polyTanTrig_dPhi = KannalaBrandtUtils_F64.polytrigDerivative(this.model.tangentTrig, cosphi, sinphi);
            this.polyRad = KannalaBrandtUtils_F64.polynomial(this.model.radial, theta);
            this.polyRadTrig = KannalaBrandtUtils_F64.polytrig(this.model.radialTrig, cosphi, sinphi);
            this.polyTan = KannalaBrandtUtils_F64.polynomial(this.model.tangent, theta);
            this.polyTanTrig = KannalaBrandtUtils_F64.polytrig(this.model.tangentTrig, cosphi, sinphi);
            double disRad_dX = polyRad_dTheta * theta_dX * this.polyRadTrig + this.polyRad * polyRadTrig_dPhi * phi_dX;
            double disRad_dY = polyRad_dTheta * theta_dY * this.polyRadTrig + this.polyRad * polyRadTrig_dPhi * phi_dY;
            double disRad_dZ = polyRad_dTheta * theta_dZ * this.polyRadTrig;
            double disTan_dX = polyTan_dTheta * theta_dX * this.polyTanTrig + this.polyTan * polyTanTrig_dPhi * phi_dX;
            double disTan_dY = polyTan_dTheta * theta_dY * this.polyTanTrig + this.polyTan * polyTanTrig_dPhi * phi_dY;
            double disTan_dZ = polyTan_dTheta * theta_dZ * this.polyTanTrig;
            distX_dX += disRad_dX * cosphi - this.polyRad * this.polyRadTrig * sinphi * phi_dX;
            distX_dY += disRad_dY * cosphi - this.polyRad * this.polyRadTrig * sinphi * phi_dY;
            distX_dZ += disRad_dZ * cosphi;
            distX_dX -= disTan_dX * sinphi + this.polyTan * this.polyTanTrig * cosphi * phi_dX;
            distX_dY -= disTan_dY * sinphi + this.polyTan * this.polyTanTrig * cosphi * phi_dY;
            distX_dZ -= disTan_dZ * sinphi;
            distY_dX += disRad_dX * sinphi + this.polyRad * this.polyRadTrig * cosphi * phi_dX;
            distY_dY += disRad_dY * sinphi + this.polyRad * this.polyRadTrig * cosphi * phi_dY;
            distY_dZ += disRad_dZ * sinphi;
            distY_dX += disTan_dX * cosphi - this.polyTan * this.polyTanTrig * sinphi * phi_dX;
            distY_dY += disTan_dY * cosphi - this.polyTan * this.polyTanTrig * sinphi * phi_dY;
            distY_dZ += disTan_dZ * cosphi;
            distX += this.polyRad * this.polyRadTrig * cosphi - this.polyTan * this.polyTanTrig * sinphi;
            distY += this.polyRad * this.polyRadTrig * sinphi + this.polyTan * this.polyTanTrig * cosphi;
        }
        pointX[0] = this.model.fx * distX_dX;
        pointX[1] = this.model.fx * distX_dY;
        pointX[2] = this.model.fx * distX_dZ;
        pointY[0] = this.model.fy * distY_dX;
        pointY[1] = this.model.fy * distY_dY;
        pointY[2] = this.model.fy * distY_dZ;
        if (!this.zeroSkew) {
            pointX[0] = pointX[0] + this.model.skew * distY_dX;
            pointX[1] = pointX[1] + this.model.skew * distY_dY;
            pointX[2] = pointX[2] + this.model.skew * distY_dZ;
        }
        if (!computeIntrinsic || calibX == null || calibY == null) {
            return;
        }
        calibX[0] = distX;
        calibY[0] = 0.0;
        calibX[1] = 0.0;
        calibY[1] = distY;
        calibX[2] = 1.0;
        calibY[2] = 0.0;
        calibX[3] = 0.0;
        calibY[3] = 1.0;
        if (!this.zeroSkew) {
            calibX[4] = distY;
            calibY[4] = 0.0;
            index = 5;
        } else {
            index = 4;
        }
        double skew = this.zeroSkew ? 0.0 : this.model.skew;
        double pows = theta;
        int i = 0;
        while (i < this.model.symmetric.length) {
            double r_d = pows;
            calibX[index] = this.model.fx * r_d * cosphi + skew * r_d * sinphi;
            calibY[index] = this.model.fy * r_d * sinphi;
            pows *= theta * theta;
            ++i;
            ++index;
        }
        if (!this.isAsymmetric) {
            return;
        }
        KannalaBrandtUtils_F64.polytrigGradient(cosphi, sinphi, this.polyTrigGradient);
        double powr = theta;
        int i2 = 0;
        while (i2 < this.model.radial.length) {
            disRad_d = powr * this.polyRadTrig;
            calibX[index] = this.model.fx * disRad_d * cosphi + skew * disRad_d * sinphi;
            calibY[index] = this.model.fy * disRad_d * sinphi;
            powr *= theta * theta;
            ++i2;
            ++index;
        }
        i2 = 0;
        while (i2 < this.polyTrigGradient.length) {
            disRad_d = this.polyRad * this.polyTrigGradient[i2];
            calibX[index] = this.model.fx * disRad_d * cosphi + skew * disRad_d * sinphi;
            calibY[index] = this.model.fy * disRad_d * sinphi;
            ++i2;
            ++index;
        }
        double powt = theta;
        int i3 = 0;
        while (i3 < this.model.tangent.length) {
            disTan_d = powt * this.polyTanTrig;
            calibX[index] = -this.model.fx * disTan_d * sinphi + skew * disTan_d * cosphi;
            calibY[index] = this.model.fy * disTan_d * cosphi;
            powt *= theta * theta;
            ++i3;
            ++index;
        }
        i3 = 0;
        while (i3 < this.polyTrigGradient.length) {
            disTan_d = this.polyTan * this.polyTrigGradient[i3];
            calibX[index] = -this.model.fx * disTan_d * sinphi + skew * disTan_d * cosphi;
            calibY[index] = this.model.fy * disTan_d * cosphi;
            ++i3;
            ++index;
        }
    }

    @Override
    public int getIntrinsicCount() {
        return this.dof;
    }

    @Override
    public BundleAdjustmentCamera setTo(Map<String, Object> map) {
        try {
            this.model.fx = (Double)BoofMiscOps.getOrThrow(map, (Object)"fx");
            this.model.fy = (Double)BoofMiscOps.getOrThrow(map, (Object)"fy");
            this.model.cx = (Double)BoofMiscOps.getOrThrow(map, (Object)"cx");
            this.model.cy = (Double)BoofMiscOps.getOrThrow(map, (Object)"cy");
            if (map.containsKey("skew")) {
                this.model.skew = (Double)BoofMiscOps.getOrThrow(map, (Object)"skew");
                this.zeroSkew = false;
            } else {
                this.model.skew = 0.0;
                this.zeroSkew = true;
            }
            this.model.symmetric = BoofMiscOps.listToArrayDouble((Object)BoofMiscOps.getOrThrow(map, (Object)"symmetric"));
            this.model.tangent = BoofMiscOps.listToArrayDouble((Object)BoofMiscOps.getOrThrow(map, (Object)"tangent"));
            this.model.radial = BoofMiscOps.listToArrayDouble((Object)BoofMiscOps.getOrThrow(map, (Object)"radial"));
            this.model.tangentTrig = BoofMiscOps.listToArrayDouble((Object)BoofMiscOps.getOrThrow(map, (Object)"tangent-trig"));
            this.model.radialTrig = BoofMiscOps.listToArrayDouble((Object)BoofMiscOps.getOrThrow(map, (Object)"radial-trig"));
            this.isAsymmetric = this.model.symmetric.length > 0;
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fx", this.model.fx);
        map.put("fy", this.model.fy);
        if (!this.zeroSkew) {
            map.put("skew", this.model.skew);
        }
        map.put("cx", this.model.cx);
        map.put("cy", this.model.cy);
        map.put("symmetric", this.model.symmetric);
        map.put("tangent", this.model.tangent);
        map.put("radial", this.model.radial);
        map.put("tangent-trig", this.model.tangentTrig);
        map.put("radial-trig", this.model.radialTrig);
        return map;
    }

    public CameraKannalaBrandt getModel() {
        return this.model;
    }

    public boolean isZeroSkew() {
        return this.zeroSkew;
    }

    public boolean isAsymmetric() {
        return this.isAsymmetric;
    }
}

