/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.BundleCameraState;
import boofcv.alg.geo.bundle.cameras.BundleZoomState;
import boofcv.misc.BoofMiscOps;
import georegression.struct.point.Point2D_F64;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.ejml.FancyPrint;
import org.jetbrains.annotations.Nullable;

public class BundleZoomSimplified
implements BundleAdjustmentCamera {
    public static final String TYPE_NAME = "ZoomSimplified";
    public double fOff = 0.0;
    public double fScale = 1.0;
    public double k1;
    public double k2;
    private double zoom = Double.NaN;

    public BundleZoomSimplified() {
    }

    public BundleZoomSimplified(double fOff, double fScale, double k1, double k2) {
        this.fOff = fOff;
        this.fScale = fScale;
        this.k1 = k1;
        this.k2 = k2;
    }

    @Override
    public void setIntrinsic(double[] parameters, int offset) {
        this.fOff = parameters[offset];
        this.fScale = parameters[offset + 1];
        this.k1 = parameters[offset + 2];
        this.k2 = parameters[offset + 3];
    }

    @Override
    public void getIntrinsic(double[] parameters, int offset) {
        parameters[offset] = this.fOff;
        parameters[offset + 1] = this.fScale;
        parameters[offset + 2] = this.k1;
        parameters[offset + 3] = this.k2;
    }

    @Override
    public void setCameraState(BundleCameraState state) {
        this.zoom = ((BundleZoomState)state).zoom;
    }

    @Override
    public void project(double camX, double camY, double camZ, Point2D_F64 output) {
        double focalLength = this.fOff + this.zoom * this.fScale;
        double normX = camX / camZ;
        double normY = camY / camZ;
        double n2 = normX * normX + normY * normY;
        double r = 1.0 + (this.k1 + this.k2 * n2) * n2;
        output.x = focalLength * r * normX;
        output.y = focalLength * r * normY;
    }

    @Override
    public void jacobian(double X, double Y, double Z, double[] inputX, double[] inputY, boolean computeIntrinsic, @Nullable double[] calibX, @Nullable double[] calibY) {
        double focalLength = this.fOff + this.zoom * this.fScale;
        double normX = X / Z;
        double normY = Y / Z;
        double n2 = normX * normX + normY * normY;
        double n2_X = 2.0 * normX / Z;
        double n2_Y = 2.0 * normY / Z;
        double n2_Z = -2.0 * n2 / Z;
        double r = 1.0 + (this.k1 + this.k2 * n2) * n2;
        double kk = this.k1 + 2.0 * this.k2 * n2;
        double r_Z = n2_Z * kk;
        inputX[0] = focalLength / Z * (r + 2.0 * normX * normX * kk);
        inputY[0] = focalLength * normY * n2_X * kk;
        inputX[1] = focalLength * normX * n2_Y * kk;
        inputY[1] = focalLength / Z * (r + 2.0 * normY * normY * kk);
        inputX[2] = focalLength * normX * (r_Z - r / Z);
        inputY[2] = focalLength * normY * (r_Z - r / Z);
        if (!computeIntrinsic || calibX == null || calibY == null) {
            return;
        }
        calibX[0] = r * normX;
        calibY[0] = r * normY;
        calibX[1] = this.zoom * r * normX;
        calibY[1] = this.zoom * r * normY;
        calibX[2] = focalLength * normX * n2;
        calibY[2] = focalLength * normY * n2;
        calibX[3] = focalLength * normX * n2 * n2;
        calibY[3] = focalLength * normY * n2 * n2;
    }

    @Override
    public int getIntrinsicCount() {
        return 4;
    }

    @Override
    public BundleAdjustmentCamera setTo(Map<String, Object> src) {
        try {
            this.fOff = (Double)BoofMiscOps.getOrThrow(src, (Object)"f-off");
            this.fScale = (Double)BoofMiscOps.getOrThrow(src, (Object)"f-scale");
            this.k1 = (Double)BoofMiscOps.getOrThrow(src, (Object)"k1");
            this.k2 = (Double)BoofMiscOps.getOrThrow(src, (Object)"k2");
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_NAME);
        map.put("f-off", this.fOff);
        map.put("f-scale", this.fScale);
        map.put("k1", this.k1);
        map.put("k2", this.k2);
        return map;
    }

    public String toString() {
        FancyPrint fp = new FancyPrint();
        return "BundleZoomSimplified{off=" + fp.s(this.fOff) + ", scale=" + fp.s(this.fScale) + ", k1=" + fp.s(this.k1) + ", k2=" + fp.s(this.k2) + "}";
    }

    public void reset() {
        this.fOff = 0.0;
        this.k2 = 0.0;
        this.k1 = 0.0;
        this.fScale = 1.0;
        this.zoom = Double.NaN;
    }

    public BundleZoomSimplified setTo(BundleZoomSimplified c) {
        this.fOff = c.fOff;
        this.fScale = c.fScale;
        this.k1 = c.k1;
        this.k2 = c.k2;
        this.zoom = c.zoom;
        return this;
    }

    public BundleZoomSimplified copy() {
        return new BundleZoomSimplified().setTo(this);
    }

    public boolean isIdentical(BundleZoomSimplified c, double tol) {
        if (Math.abs(this.fOff - c.fOff) > tol) {
            return false;
        }
        if (Math.abs(this.fScale - c.fScale) > tol) {
            return false;
        }
        if (Math.abs(this.k1 - c.k1) > tol) {
            return false;
        }
        return !(Math.abs(this.k2 - c.k2) > tol);
    }
}

