/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.rectify;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class DisparityParameters {
    public int disparityMin;
    public int disparityRange;
    public double baseline;
    public final CameraPinhole pinhole = new CameraPinhole();
    public final DMatrixRMaj rotateToRectified = CommonOps_DDRM.identity((int)3);

    public DisparityParameters() {
    }

    public DisparityParameters(int disparityMin, int disparityRange, double baseline, CameraPinhole pinhole) {
        this.disparityMin = disparityMin;
        this.disparityRange = disparityRange;
        this.baseline = baseline;
        this.pinhole.setTo(pinhole);
    }

    public boolean pixelToLeft3D(double pixelX, double pixelY, double value, Point3D_F64 location) {
        if (value >= (double)this.disparityRange) {
            return false;
        }
        if ((value += (double)this.disparityMin) == 0.0) {
            return false;
        }
        location.z = this.baseline * this.pinhole.fx / value;
        location.x = location.z * (pixelX - this.pinhole.cx) / this.pinhole.fx;
        location.y = location.z * (pixelY - this.pinhole.cy) / this.pinhole.fy;
        GeometryMath_F64.multTran((DMatrixRMaj)this.rotateToRectified, (GeoTuple3D_F64)location, (GeoTuple3D_F64)location);
        return true;
    }

    public boolean pixelToLeft4D(double pixelX, double pixelY, double value, Point4D_F64 location) {
        BoofMiscOps.checkTrue((value >= 0.0 ? 1 : 0) != 0, (String)"Negative disparity value? BUG!");
        if (value >= (double)this.disparityRange) {
            return false;
        }
        location.w = value += (double)this.disparityMin;
        location.z = this.baseline * this.pinhole.fx;
        location.x = location.z * (pixelX - this.pinhole.cx) / this.pinhole.fx;
        location.y = location.z * (pixelY - this.pinhole.cy) / this.pinhole.fy;
        PerspectiveOps.rotateInvH(this.rotateToRectified, location, location);
        return true;
    }

    public void reset() {
        this.disparityMin = 0;
        this.disparityRange = 0;
        this.baseline = 0.0;
        this.pinhole.fsetK(0.0, 0.0, 0.0, 0.0, 0.0, 0, 0);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.rotateToRectified);
    }

    public DisparityParameters setTo(DisparityParameters src) {
        this.disparityMin = src.disparityMin;
        this.disparityRange = src.disparityRange;
        this.baseline = src.baseline;
        this.pinhole.setTo(src.pinhole);
        this.rotateToRectified.setTo((DMatrixD1)src.rotateToRectified);
        return this;
    }

    public void checkValidity() {
        BoofMiscOps.checkTrue((this.disparityMin >= 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.disparityRange > 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.baseline > 0.0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.pinhole.fx > 0.0 ? 1 : 0) != 0);
    }

    public int getDisparityMin() {
        return this.disparityMin;
    }

    public int getDisparityRange() {
        return this.disparityRange;
    }

    public double getBaseline() {
        return this.baseline;
    }

    public CameraPinhole getPinhole() {
        return this.pinhole;
    }

    public DMatrixRMaj getRotateToRectified() {
        return this.rotateToRectified;
    }

    public void setDisparityMin(int disparityMin) {
        this.disparityMin = disparityMin;
    }

    public void setDisparityRange(int disparityRange) {
        this.disparityRange = disparityRange;
    }

    public void setBaseline(double baseline) {
        this.baseline = baseline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisparityParameters)) {
            return false;
        }
        DisparityParameters other = (DisparityParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDisparityMin() != other.getDisparityMin()) {
            return false;
        }
        if (this.getDisparityRange() != other.getDisparityRange()) {
            return false;
        }
        if (Double.compare(this.getBaseline(), other.getBaseline()) != 0) {
            return false;
        }
        CameraPinhole this$pinhole = this.getPinhole();
        CameraPinhole other$pinhole = other.getPinhole();
        if (this$pinhole == null ? other$pinhole != null : !((Object)this$pinhole).equals(other$pinhole)) {
            return false;
        }
        DMatrixRMaj this$rotateToRectified = this.getRotateToRectified();
        DMatrixRMaj other$rotateToRectified = other.getRotateToRectified();
        return !(this$rotateToRectified == null ? other$rotateToRectified != null : !this$rotateToRectified.equals(other$rotateToRectified));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DisparityParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDisparityMin();
        result = result * 59 + this.getDisparityRange();
        long $baseline = Double.doubleToLongBits(this.getBaseline());
        result = result * 59 + (int)($baseline >>> 32 ^ $baseline);
        CameraPinhole $pinhole = this.getPinhole();
        result = result * 59 + ($pinhole == null ? 43 : ((Object)$pinhole).hashCode());
        DMatrixRMaj $rotateToRectified = this.getRotateToRectified();
        result = result * 59 + ($rotateToRectified == null ? 43 : $rotateToRectified.hashCode());
        return result;
    }

    public String toString() {
        return "DisparityParameters(disparityMin=" + this.getDisparityMin() + ", disparityRange=" + this.getDisparityRange() + ", baseline=" + this.getBaseline() + ", pinhole=" + this.getPinhole() + ", rotateToRectified=" + this.getRotateToRectified() + ")";
    }
}

