/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.Triangulate2PointingMetricH;
import boofcv.alg.geo.DistanceFromModelMultiView2;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.PointingToProjectedPixelError;
import boofcv.struct.distort.Point3Transform2_F64;
import boofcv.struct.geo.AssociatedPair3D;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;

public class DistanceSe3SymmetricSqPointing
implements DistanceFromModelMultiView2<Se3_F64, AssociatedPair3D> {
    private Se3_F64 keyToCurr;
    private Triangulate2PointingMetricH triangulator;
    private Point4D_F64 p = new Point4D_F64();
    private PointingToProjectedPixelError errorCam1 = new PointingToProjectedPixelError();
    private PointingToProjectedPixelError errorCam2 = new PointingToProjectedPixelError();

    public DistanceSe3SymmetricSqPointing(Triangulate2PointingMetricH triangulator) {
        this.triangulator = triangulator;
    }

    public void setModel(Se3_F64 keyToCurr) {
        this.keyToCurr = keyToCurr;
    }

    public double distance(AssociatedPair3D obs) {
        if (!this.triangulator.triangulate(obs.p1, obs.p2, this.keyToCurr, this.p)) {
            throw new RuntimeException("Triangulate failed. p1=" + obs.p1 + " p2=" + obs.p2);
        }
        if (PerspectiveOps.isBehindCamera(this.p)) {
            return Double.MAX_VALUE;
        }
        double error = this.errorCam1.errorSq(obs.p1.x, obs.p1.y, obs.p1.z, this.p.x, this.p.y, this.p.z);
        SePointOps_F64.transform((Se3_F64)this.keyToCurr, (Point4D_F64)this.p, (Point4D_F64)this.p);
        if (PerspectiveOps.isBehindCamera(this.p)) {
            return Double.MAX_VALUE;
        }
        return error += this.errorCam2.errorSq(obs.p2.x, obs.p2.y, obs.p2.z, this.p.x, this.p.y, this.p.z);
    }

    public void distances(List<AssociatedPair3D> associatedPairs, double[] distance) {
        for (int i = 0; i < associatedPairs.size(); ++i) {
            AssociatedPair3D obs = associatedPairs.get(i);
            distance[i] = this.distance(obs);
        }
    }

    public Class<AssociatedPair3D> getPointType() {
        return AssociatedPair3D.class;
    }

    public Class<Se3_F64> getModelType() {
        return Se3_F64.class;
    }

    @Override
    public void setDistortion(int view, Point3Transform2_F64 intrinsic) {
        if (view == 0) {
            this.errorCam1.setCamera(intrinsic);
        } else if (view == 1) {
            this.errorCam2.setCamera(intrinsic);
        } else {
            throw new IllegalArgumentException("View must be 0 or 1");
        }
    }

    @Override
    public int getNumberOfViews() {
        return 2;
    }
}

