/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.geo;

import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;

public class AssociatedPair3D {
    public Point3D_F64 p1;
    public Point3D_F64 p2;

    public AssociatedPair3D() {
        this.p1 = new Point3D_F64();
        this.p2 = new Point3D_F64();
    }

    public AssociatedPair3D(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.p1 = new Point3D_F64(x1, y1, z1);
        this.p2 = new Point3D_F64(x2, y2, z2);
    }

    public AssociatedPair3D(Point3D_F64 p1, Point3D_F64 p2) {
        this(p1, p2, true);
    }

    public AssociatedPair3D(Point3D_F64 p1, Point3D_F64 p2, boolean newInstance) {
        if (newInstance) {
            this.p1 = new Point3D_F64((GeoTuple3D_F64)p1);
            this.p2 = new Point3D_F64((GeoTuple3D_F64)p2);
        } else {
            this.p1 = p1;
            this.p2 = p2;
        }
    }

    public static AssociatedPair3D wrap(Point3D_F64 p1, Point3D_F64 p2) {
        return new AssociatedPair3D(p1, p2, false);
    }

    public AssociatedPair3D setTo(AssociatedPair3D original) {
        this.p1.setTo(original.p1);
        this.p2.setTo(original.p2);
        return this;
    }

    public AssociatedPair3D setTo(Point3D_F64 p1, Point3D_F64 p2) {
        this.p1.setTo(p1);
        this.p2.setTo(p2);
        return this;
    }

    public AssociatedPair3D setTo(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.p1.setTo(x1, y1, z1);
        this.p2.setTo(x2, y2, z2);
        return this;
    }

    public void normalizePoints() {
        this.p1.divideIP(this.p1.norm());
        this.p2.divideIP(this.p2.norm());
    }

    public void assign(Point3D_F64 p1, Point3D_F64 p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public void zero() {
        this.p1.zero();
        this.p2.zero();
    }

    public AssociatedPair3D copy() {
        return new AssociatedPair3D(this.p1, this.p2, true);
    }

    public String toString() {
        return "AssociatedPair3D{p1=" + this.p1 + ", p2=" + this.p2 + "}";
    }

    public Point3D_F64 getP1() {
        return this.p1;
    }

    public Point3D_F64 getP2() {
        return this.p2;
    }
}

