/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.selfcalib;

import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.robust.ModelGeneratorViews;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.alg.geo.trifocal.TrifocalExtractGeometries;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.AssociatedTuple;
import boofcv.struct.geo.AssociatedTupleN;
import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;

public class GenerateMetricTripleFromProjective
implements ModelGeneratorViews<MetricCameraTriple, AssociatedTriple, ElevateViewInfo> {
    public Estimate1ofTrifocalTensor trifocal;
    public ProjectiveToMetricCameras projectiveToMetric;
    final TrifocalExtractGeometries extractor = new TrifocalExtractGeometries();
    final TrifocalTensor tensor = new TrifocalTensor();
    final DMatrixRMaj P2;
    final DMatrixRMaj P3;
    final DogArray<AssociatedTuple> observationsN = new DogArray(() -> new AssociatedTupleN(3));
    final DogArray<DMatrixRMaj> projective = new DogArray(() -> new DMatrixRMaj(3, 4));
    final DogArray<ElevateViewInfo> views = new DogArray(ElevateViewInfo::new);
    final MetricCameras metricN = new MetricCameras();

    public GenerateMetricTripleFromProjective(Estimate1ofTrifocalTensor trifocal, ProjectiveToMetricCameras projectiveToMetric) {
        this.trifocal = trifocal;
        this.projectiveToMetric = projectiveToMetric;
        this.views.resize(3);
        this.projective.resize(2);
        this.P2 = (DMatrixRMaj)this.projective.get(0);
        this.P3 = (DMatrixRMaj)this.projective.get(1);
    }

    @Override
    public void setView(int view, ElevateViewInfo viewInfo) {
        ((ElevateViewInfo)this.views.get(view)).setTo(viewInfo);
    }

    @Override
    public int getNumberOfViews() {
        return 3;
    }

    public boolean generate(List<AssociatedTriple> observationTriple, MetricCameraTriple output) {
        if (!this.trifocal.process(observationTriple, this.tensor)) {
            return false;
        }
        this.extractor.setTensor(this.tensor);
        this.extractor.extractCamera(this.P2, this.P3);
        MultiViewOps.convertTr(observationTriple, this.observationsN);
        if (!this.projectiveToMetric.process(this.views.toList(), this.projective.toList(), this.observationsN.toList(), this.metricN)) {
            return false;
        }
        output.view_1_to_2.setTo((Se3_F64)this.metricN.motion_1_to_k.get(0));
        output.view_1_to_3.setTo((Se3_F64)this.metricN.motion_1_to_k.get(1));
        output.view1.setTo((CameraPinhole)this.metricN.intrinsics.get(0));
        output.view2.setTo((CameraPinhole)this.metricN.intrinsics.get(1));
        output.view3.setTo((CameraPinhole)this.metricN.intrinsics.get(2));
        return true;
    }

    public int getMinimumPoints() {
        return this.trifocal.getMinimumPoints();
    }

    public TrifocalExtractGeometries getExtractor() {
        return this.extractor;
    }

    public TrifocalTensor getTensor() {
        return this.tensor;
    }

    public DMatrixRMaj getP2() {
        return this.P2;
    }

    public DMatrixRMaj getP3() {
        return this.P3;
    }

    public DogArray<AssociatedTuple> getObservationsN() {
        return this.observationsN;
    }

    public DogArray<DMatrixRMaj> getProjective() {
        return this.projective;
    }

    public DogArray<ElevateViewInfo> getViews() {
        return this.views;
    }

    public MetricCameras getMetricN() {
        return this.metricN;
    }
}

