/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.triangulate;

import boofcv.abst.geo.RefineTriangulateEpipolar;
import boofcv.alg.geo.triangulate.ResidualsTriangulateEpipolarSampson;
import boofcv.misc.BoofMiscOps;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixRMaj;

public class TriangulateRefineEpipolarLS
implements RefineTriangulateEpipolar {
    final ResidualsTriangulateEpipolarSampson func = new ResidualsTriangulateEpipolarSampson();
    final UnconstrainedLeastSquares<DMatrixRMaj> minimizer;
    final double[] param = new double[3];
    int maxIterations;
    double convergenceTol;

    public TriangulateRefineEpipolarLS(double convergenceTol, int maxIterations) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.minimizer = FactoryOptimization.levenbergMarquardt(null, (boolean)false);
        BoofMiscOps.checkEq((int)3, (int)this.func.getNumOfInputsN());
    }

    @Override
    public boolean process(List<Point2D_F64> observations, List<DMatrixRMaj> fundamentalWorldToCam, Point3D_F64 worldPt, Point3D_F64 refinedPt) {
        this.func.setObservations(observations, fundamentalWorldToCam);
        this.minimizer.setFunction((FunctionNtoM)this.func, null);
        this.param[0] = worldPt.x;
        this.param[1] = worldPt.y;
        this.param[2] = worldPt.z;
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)observations.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        double[] found = this.minimizer.getParameters();
        refinedPt.x = found[0];
        refinedPt.y = found[1];
        refinedPt.z = found[2];
        return true;
    }

    public ResidualsTriangulateEpipolarSampson getFunc() {
        return this.func;
    }

    public UnconstrainedLeastSquares<DMatrixRMaj> getMinimizer() {
        return this.minimizer;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getConvergenceTol() {
        return this.convergenceTol;
    }

    public void setConvergenceTol(double convergenceTol) {
        this.convergenceTol = convergenceTol;
    }
}

