/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.cloud;

import boofcv.struct.Point3dRgbI_F32;
import boofcv.struct.Point3dRgbI_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;

public interface PointCloudWriter {
    public void initialize(int var1, boolean var2);

    public void startPoint();

    public void stopPoint();

    public void location(double var1, double var3, double var5);

    public void color(int var1);

    public static PointCloudWriter wrapF32(final DogArray<Point3D_F32> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reserve(size);
                cloud.reset();
            }

            @Override
            public void startPoint() {
            }

            @Override
            public void stopPoint() {
            }

            @Override
            public void location(double x, double y, double z) {
                ((Point3D_F32)cloud.grow()).setTo((float)x, (float)y, (float)z);
            }

            @Override
            public void color(int rgb) {
            }
        };
    }

    public static PointCloudWriter wrapF64(final DogArray<Point3D_F64> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reserve(size);
                cloud.reset();
            }

            @Override
            public void startPoint() {
            }

            @Override
            public void stopPoint() {
            }

            @Override
            public void color(int rgb) {
            }

            @Override
            public void location(double x, double y, double z) {
                ((Point3D_F64)cloud.grow()).setTo(x, y, z);
            }
        };
    }

    public static PointCloudWriter wrapF64(final DogArray<Point3D_F64> cloud, final DogArray_I32 colors) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reserve(size);
                cloud.reset();
                colors.reserve(size);
                colors.reset();
            }

            @Override
            public void startPoint() {
            }

            @Override
            public void stopPoint() {
            }

            @Override
            public void color(int rgb) {
                colors.add(rgb);
            }

            @Override
            public void location(double x, double y, double z) {
                ((Point3D_F64)cloud.grow()).setTo(x, y, z);
            }
        };
    }

    public static PointCloudWriter wrapF32RGB(final DogArray<Point3dRgbI_F32> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reserve(size);
                cloud.reset();
            }

            @Override
            public void startPoint() {
                cloud.grow();
            }

            @Override
            public void stopPoint() {
            }

            @Override
            public void location(double x, double y, double z) {
                ((Point3dRgbI_F32)cloud.getTail()).setTo((float)x, (float)y, (float)z);
            }

            @Override
            public void color(int rgb) {
                ((Point3dRgbI_F32)cloud.getTail()).rgb = rgb;
            }
        };
    }

    public static PointCloudWriter wrapF64RGB(final DogArray<Point3dRgbI_F64> cloud) {
        return new PointCloudWriter(){

            @Override
            public void initialize(int size, boolean hasColor) {
                cloud.reset();
            }

            @Override
            public void startPoint() {
                cloud.grow();
            }

            @Override
            public void stopPoint() {
            }

            @Override
            public void location(double x, double y, double z) {
                ((Point3dRgbI_F64)cloud.getTail()).setTo(x, y, z);
            }

            @Override
            public void color(int rgb) {
                ((Point3dRgbI_F64)cloud.getTail()).rgb = rgb;
            }
        };
    }

    public static class CloudArraysF32
    implements PointCloudWriter {
        public DogArray_F32 cloudXyz = new DogArray_F32();
        public DogArray_I32 cloudRgb = new DogArray_I32();

        @Override
        public void initialize(int size, boolean hasColor) {
            this.cloudRgb.reset();
            this.cloudXyz.reset();
            this.cloudRgb.reserve(size);
            this.cloudXyz.reserve(size * 3);
        }

        @Override
        public void startPoint() {
        }

        @Override
        public void stopPoint() {
        }

        @Override
        public void location(double x, double y, double z) {
            this.cloudXyz.add((float)x);
            this.cloudXyz.add((float)y);
            this.cloudXyz.add((float)z);
        }

        @Override
        public void color(int rgb) {
            this.cloudRgb.add(rgb);
        }

        public void getPoint(int index, Point3D_F64 p) {
            int i = index * 3;
            p.x = this.cloudXyz.data[i];
            p.y = this.cloudXyz.data[i + 1];
            p.z = this.cloudXyz.data[i + 2];
        }
    }
}

