/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.division;

import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;

public class AddDivisionNtoN_F64
implements Point2Transform2_F64 {
    public double radial;
    public double tol = 1.0E-8;
    public int maxIterations = 500;

    public AddDivisionNtoN_F64 setRadial(double radial) {
        this.radial = radial;
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        double origX = x;
        double origY = y;
        double prevR2 = 0.0;
        for (int iter = 0; iter < this.maxIterations; ++iter) {
            double r2 = x * x + y * y;
            x = origX * (1.0 + this.radial * r2);
            y = origY * (1.0 + this.radial * r2);
            if (Math.abs(r2 - prevR2) <= this.tol) break;
            prevR2 = r2;
        }
        out.setTo(x, y);
    }

    public AddDivisionNtoN_F64 copyConcurrent() {
        AddDivisionNtoN_F64 ret = new AddDivisionNtoN_F64();
        ret.radial = this.radial;
        return ret;
    }
}

