/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.universal;

import boofcv.alg.distort.brown.RadialTangential_F32;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.Point3Transform2_F32;
import georegression.struct.point.Point2D_F32;

public class UniOmniStoP_F32
implements Point3Transform2_F32 {
    float mirrorOffset;
    protected float cx;
    protected float cy;
    protected float fx;
    protected float fy;
    protected float skew;
    protected RadialTangential_F32 distortion = new RadialTangential_F32();

    public UniOmniStoP_F32(CameraUniversalOmni model) {
        this.setModel(model);
    }

    public UniOmniStoP_F32() {
    }

    public void setModel(CameraUniversalOmni model) {
        this.mirrorOffset = (float)model.mirrorOffset;
        this.distortion.setTo(model.radial, model.t1, model.t2);
        this.cx = (float)model.cx;
        this.cy = (float)model.cy;
        this.fx = (float)model.fx;
        this.fy = (float)model.fy;
        this.skew = (float)model.skew;
    }

    public void compute(float x, float y, float z, Point2D_F32 out) {
        float r2;
        float[] radial = this.distortion.radial;
        float t1 = this.distortion.t1;
        float t2 = this.distortion.t2;
        float ri2 = r2 = (x /= (z += this.mirrorOffset)) * x + (y /= z) * y;
        float sum = 0.0f;
        for (int i = 0; i < radial.length; ++i) {
            sum += radial[i] * ri2;
            ri2 *= r2;
        }
        float dx = x * (1.0f + sum) + 2.0f * t1 * x * y + t2 * (r2 + 2.0f * x * x);
        float dy = y * (1.0f + sum) + t1 * (r2 + 2.0f * y * y) + 2.0f * t2 * x * y;
        out.x = this.fx * dx + this.skew * dy + this.cx;
        out.y = this.fy * dy + this.cy;
    }

    public Point3Transform2_F32 copyConcurrent() {
        UniOmniStoP_F32 c = new UniOmniStoP_F32();
        c.distortion = new RadialTangential_F32(this.distortion);
        c.mirrorOffset = this.mirrorOffset;
        c.cx = this.cx;
        c.cy = this.cy;
        c.fx = this.fx;
        c.fy = this.fy;
        c.skew = this.skew;
        return c;
    }
}

