/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle.cameras;

import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import georegression.struct.point.Point2D_F64;
import org.jetbrains.annotations.Nullable;

public class BundlePinholeSnavely
extends BundlePinholeSimplified {
    @Override
    public void project(double camX, double camY, double camZ, Point2D_F64 output) {
        super.project(camX, camY, -camZ, output);
    }

    @Override
    public void jacobian(double X, double Y, double Z, double[] inputX, double[] inputY, boolean computeIntrinsic, @Nullable double[] calibX, @Nullable double[] calibY) {
        Z = -Z;
        double normX = X / Z;
        double normY = Y / Z;
        double n2 = normX * normX + normY * normY;
        double n2_X = 2.0 * normX / Z;
        double n2_Y = 2.0 * normY / Z;
        double n2_Z = -2.0 * n2 / Z;
        double r = 1.0 + (this.k1 + this.k2 * n2) * n2;
        double kk = this.k1 + 2.0 * this.k2 * n2;
        double r_Z = n2_Z * kk;
        inputX[0] = this.f / Z * (r + 2.0 * normX * normX * kk);
        inputY[0] = this.f * normY * n2_X * kk;
        inputX[1] = this.f * normX * n2_Y * kk;
        inputY[1] = this.f / Z * (r + 2.0 * normY * normY * kk);
        inputX[2] = this.f * normX * (r / Z - r_Z);
        inputY[2] = this.f * normY * (r / Z - r_Z);
        if (!computeIntrinsic || calibX == null || calibY == null) {
            return;
        }
        calibX[0] = r * normX;
        calibY[0] = r * normY;
        calibX[1] = this.f * normX * n2;
        calibY[1] = this.f * normY * n2;
        calibX[2] = this.f * normX * n2 * n2;
        calibY[2] = this.f * normY * n2 * n2;
    }

    @Override
    public String toString() {
        return "BundlePinholeSnavely{f=" + this.f + ", k1=" + this.k1 + ", k2=" + this.k2 + "}";
    }
}

