/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.Triangulate2PointingMetricH;
import boofcv.alg.geo.PositiveDepthConstraintCheckHPointing;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair3D;
import georegression.struct.se.Se3_F64;
import java.util.List;

public class SelectBestStereoTransformHPointing {
    PositiveDepthConstraintCheckHPointing depthCheck;

    public SelectBestStereoTransformHPointing(Triangulate2PointingMetricH triangulate) {
        this.depthCheck = new PositiveDepthConstraintCheckHPointing(triangulate);
    }

    public SelectBestStereoTransformHPointing() {
        this(FactoryMultiView.triangulate2PointingMetricH(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC)));
    }

    public void select(List<Se3_F64> candidatesAtoB, List<AssociatedPair3D> observations, Se3_F64 model) {
        Se3_F64 bestModel = null;
        int bestCount = -1;
        for (int i = 0; i < candidatesAtoB.size(); ++i) {
            Se3_F64 s = candidatesAtoB.get(i);
            int count = 0;
            for (int pairIdx = 0; pairIdx < observations.size(); ++pairIdx) {
                AssociatedPair3D p = observations.get(pairIdx);
                if (!this.depthCheck.checkConstraint(p.p1, p.p2, s)) continue;
                ++count;
            }
            if (count <= bestCount) continue;
            bestCount = count;
            bestModel = s;
        }
        if (bestModel == null) {
            throw new RuntimeException("BUG");
        }
        model.setTo(bestModel);
    }
}

