/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.PerspectiveOps;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrix4x4;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.ops.DConvertMatrixStruct;

public class SelfCalibrationBase {
    DogArray<Projective> cameras = new DogArray(Projective::new);
    int minimumProjectives;
    DMatrixRMaj _P = new DMatrixRMaj(3, 4);
    DMatrixRMaj _Q = new DMatrixRMaj(4, 4);
    DMatrixRMaj tmp = new DMatrixRMaj(3, 4);

    public void addCameraMatrix(DMatrixRMaj viewI) {
        Projective pr = (Projective)this.cameras.grow();
        PerspectiveOps.projectionSplit(viewI, pr.A, pr.a);
    }

    public void addCameraMatrix(List<DMatrixRMaj> viewI_to_view0) {
        for (int i = 0; i < viewI_to_view0.size(); ++i) {
            this.addCameraMatrix(viewI_to_view0.get(i));
        }
    }

    public static void encodeQ(DMatrix4x4 Q, double[] param) {
        Q.a11 = param[0];
        Q.a12 = Q.a21 = param[1];
        Q.a13 = Q.a31 = param[2];
        Q.a14 = Q.a41 = param[3];
        Q.a22 = param[4];
        Q.a23 = Q.a32 = param[5];
        Q.a24 = Q.a42 = param[6];
        Q.a33 = param[7];
        Q.a34 = Q.a43 = param[8];
        Q.a44 = param[9];
    }

    public void computeW(Projective P, DMatrix4x4 Q, DMatrixRMaj w_i) {
        DConvertMatrixStruct.convert((DMatrix4x4)Q, (DMatrixRMaj)this._Q);
        SelfCalibrationBase.convert(P, this._P);
        CommonOps_DDRM.mult((DMatrix1Row)this._P, (DMatrix1Row)this._Q, (DMatrix1Row)this.tmp);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.tmp, (DMatrix1Row)this._P, (DMatrix1Row)w_i);
        CommonOps_DDRM.divide((DMatrixD1)w_i, (double)w_i.get(2, 2));
    }

    static void convert(Projective P, DMatrixRMaj D) {
        D.data[0] = P.A.a11;
        D.data[1] = P.A.a12;
        D.data[2] = P.A.a13;
        D.data[3] = P.a.a1;
        D.data[4] = P.A.a21;
        D.data[5] = P.A.a22;
        D.data[6] = P.A.a23;
        D.data[7] = P.a.a2;
        D.data[8] = P.A.a31;
        D.data[9] = P.A.a32;
        D.data[10] = P.A.a33;
        D.data[11] = P.a.a3;
    }

    public int getMinimumProjectives() {
        return this.minimumProjectives;
    }

    public static class Projective {
        protected DMatrix3x3 A = new DMatrix3x3();
        protected DMatrix3 a = new DMatrix3();
    }
}

