/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import java.io.Serializable;
import java.util.Arrays;
import org.ejml.FancyPrint;
import org.jetbrains.annotations.Nullable;

public class CameraPinholeBrown
extends CameraPinhole
implements Serializable {
    @Nullable
    public double[] radial;
    public double t1;
    public double t2;

    public CameraPinholeBrown() {
    }

    public CameraPinholeBrown(int numRadial) {
        this.radial = new double[numRadial];
    }

    public CameraPinholeBrown(CameraPinholeBrown param) {
        this.setTo(param);
    }

    public CameraPinholeBrown(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        this.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.radial != null) {
            Arrays.fill(this.radial, 0.0);
        }
        this.t2 = 0.0;
        this.t1 = 0.0;
    }

    @Override
    public CameraPinholeBrown fsetK(double fx, double fy, double skew, double cx, double cy, int width, int height) {
        return (CameraPinholeBrown)super.fsetK(fx, fy, skew, cx, cy, width, height);
    }

    public CameraPinholeBrown fsetRadial(double ... radial) {
        if (radial == null) {
            this.radial = null;
        } else if (this.radial == null || this.radial.length != radial.length) {
            this.radial = (double[])radial.clone();
        } else {
            for (int i = 0; i < radial.length; ++i) {
                this.radial[i] = radial[i];
            }
        }
        return this;
    }

    public CameraPinholeBrown fsetTangential(double t1, double t2) {
        this.t1 = t1;
        this.t2 = t2;
        return this;
    }

    public CameraPinholeBrown setTo(CameraPinholeBrown param) {
        CameraPinholeBrown p = param;
        p.fsetRadial(p.radial);
        this.radial = (double[])(p.radial != null ? (double[])p.radial.clone() : null);
        this.t1 = p.t1;
        this.t2 = p.t2;
        super.setTo(param);
        return this;
    }

    @Override
    public CameraPinhole setTo(CameraPinhole param) {
        if (param instanceof CameraPinholeBrown) {
            this.setTo((CameraPinholeBrown)param);
        } else {
            this.radial = null;
            this.t1 = 0.0;
            this.t2 = 0.0;
            super.setTo(param);
        }
        return this;
    }

    public boolean isDistorted() {
        if (this.radial != null && this.radial.length > 0) {
            for (int i = 0; i < this.radial.length; ++i) {
                if (this.radial[i] == 0.0) continue;
                return true;
            }
        }
        return this.t1 != 0.0 || this.t2 != 0.0;
    }

    public boolean isDistorted(double tol) {
        if (this.radial != null && this.radial.length > 0) {
            for (int i = 0; i < this.radial.length; ++i) {
                if (!(Math.abs(this.radial[i]) > tol)) continue;
                return true;
            }
        }
        return Math.abs(this.t1) > tol || Math.abs(this.t2) > tol;
    }

    @Nullable
    public double[] getRadial() {
        return this.radial;
    }

    public void setRadial(double ... radial) {
        this.radial = radial;
    }

    @Override
    public void print() {
        super.print();
        if (this.radial != null) {
            for (int i = 0; i < this.radial.length; ++i) {
                System.out.printf("radial[%d] = %6.2e\n", i, this.radial[i]);
            }
        } else {
            System.out.println("No radial");
        }
        if (this.t1 != 0.0 || this.t2 != 0.0) {
            System.out.printf("tangential = ( %6.2e , %6.2e)\n", this.t1, this.t2);
        } else {
            System.out.println("No tangential");
        }
    }

    @Override
    public String toString() {
        FancyPrint fp = new FancyPrint();
        String txt = "CameraPinholeRadial{fx=" + this.fx + ", fy=" + this.fy + ", skew=" + this.skew + ", cx=" + this.cx + ", cy=" + this.cy + ", width=" + this.width + ", height=" + this.height;
        txt = txt + CameraPinholeBrown.toStringArray(fp, "r", this.radial);
        if (this.t1 != 0.0 || this.t2 != 0.0) {
            txt = txt + ", t1=" + fp.s(this.t1) + " t2=" + fp.s(this.t2);
        }
        txt = txt + "}";
        return txt;
    }

    public static String toStringArray(FancyPrint fp, String name, @Nullable double[] param) {
        if (param == null || param.length == 0) {
            return "";
        }
        Object txt = ",";
        for (int i = 0; i < param.length; ++i) {
            txt = (String)txt + " " + name + i + "=" + fp.s(param[i]);
        }
        return txt;
    }

    @Override
    public <T extends CameraModel> T createLike() {
        CameraPinholeBrown model = new CameraPinholeBrown();
        if (this.radial != null) {
            model.radial = new double[this.radial.length];
        }
        return (T)model;
    }

    public double getT1() {
        return this.t1;
    }

    public double getT2() {
        return this.t2;
    }

    public void setT1(double t1) {
        this.t1 = t1;
    }

    public void setT2(double t2) {
        this.t2 = t2;
    }
}

