/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.struct.mesh.MeshPolygonAccess;
import georegression.fitting.plane.FitPlane3D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.ddogleg.struct.DogArray;

public class StlFileWriter {
    FitPlane3D_F64 fitPlane = new FitPlane3D_F64();
    Point3D_F64 center = new Point3D_F64();
    Vector3D_F64 normal = new Vector3D_F64();
    Vector3D_F64 va = new Vector3D_F64();
    Vector3D_F64 vb = new Vector3D_F64();
    Vector3D_F64 tempN = new Vector3D_F64();
    final byte[] line = new byte[80];
    public String precision = "%.10f";
    public HandleBadPolygon errorHandler = (w, e) -> System.err.println("Bad Polygon: " + w + " " + e);

    public void writeAscii(MeshPolygonAccess mesh, String name, Writer writer) throws IOException {
        String nameMassaged = name.trim().replaceAll("\\s", "");
        writer.write("solid " + nameMassaged + "\n");
        String formatNorm = String.format("  facet normal %s %s %s\n", this.precision, this.precision, this.precision);
        String formatVert = String.format("      vertex %s %s %s\n", this.precision, this.precision, this.precision);
        DogArray poly = new DogArray(Point3D_F64::new);
        for (int polygonIdx = 0; polygonIdx < mesh.size(); ++polygonIdx) {
            mesh.getPolygon(polygonIdx, poly);
            if (!this.computeNormal((DogArray<Point3D_F64>)poly, polygonIdx)) continue;
            Point3D_F64 p0 = (Point3D_F64)poly.get(0);
            for (int idx1 = 3; idx1 <= poly.size; ++idx1) {
                int idx0;
                writer.write(String.format(formatNorm, this.normal.x, this.normal.y, this.normal.z));
                writer.write("    outer loop\n");
                writer.write(String.format(formatVert, p0.x, p0.y, p0.z));
                for (int i = idx0 = idx1 - 2; i < idx1; ++i) {
                    Point3D_F64 p = (Point3D_F64)poly.get(i);
                    writer.write(String.format(formatVert, p.x, p.y, p.z));
                }
                writer.write("    endloop\n");
                writer.write("  endfacet\n");
            }
        }
        writer.write("endsolid " + nameMassaged + "\n");
    }

    public void writeBinary(MeshPolygonAccess mesh, String name, OutputStream output) throws IOException {
        int polygonIdx;
        Arrays.fill(this.line, (byte)0);
        ByteBuffer bb = ByteBuffer.wrap(this.line);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.mark();
        DogArray poly = new DogArray(Point3D_F64::new);
        String nameMassaged = name.trim().replaceAll("\\s", "");
        byte[] nameBytes = nameMassaged.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(nameBytes, 0, this.line, 0, Math.min(nameBytes.length, 80));
        output.write(this.line, 0, 80);
        int totalTriangles = 0;
        for (polygonIdx = 0; polygonIdx < mesh.size(); ++polygonIdx) {
            mesh.getPolygon(polygonIdx, poly);
            totalTriangles += poly.size - 2;
        }
        bb.putInt(totalTriangles);
        output.write(this.line, 0, 4);
        for (polygonIdx = 0; polygonIdx < mesh.size(); ++polygonIdx) {
            mesh.getPolygon(polygonIdx, poly);
            if (!this.computeNormal((DogArray<Point3D_F64>)poly, polygonIdx)) continue;
            Point3D_F64 p0 = (Point3D_F64)poly.get(0);
            for (int idx1 = 3; idx1 <= poly.size; ++idx1) {
                bb.reset();
                this.putGeoTuple3(bb, (GeoTuple3D_F64<?>)this.normal);
                this.putGeoTuple3(bb, (GeoTuple3D_F64<?>)p0);
                this.putGeoTuple3(bb, (GeoTuple3D_F64)poly.get(idx1 - 2));
                this.putGeoTuple3(bb, (GeoTuple3D_F64)poly.get(idx1 - 1));
                bb.putShort((short)0);
                output.write(this.line, 0, bb.position());
            }
        }
    }

    private void putGeoTuple3(ByteBuffer bb, GeoTuple3D_F64<?> n) {
        bb.putFloat((float)n.x);
        bb.putFloat((float)n.y);
        bb.putFloat((float)n.z);
    }

    boolean computeNormal(DogArray<Point3D_F64> poly, int polygonIdx) {
        if (poly.size == 3) {
            this.va.minus((Point3D_F64)poly.get(1), (Point3D_F64)poly.get(0));
            this.vb.minus((Point3D_F64)poly.get(2), (Point3D_F64)poly.get(0));
            this.normal.crossSetTo(this.va, this.vb);
        } else {
            if (!this.fitPlane.svd(poly.toList(), this.center, this.normal)) {
                this.errorHandler.handleError(polygonIdx, "Failed to find normal");
                return false;
            }
            this.va.minus((Point3D_F64)poly.get(1), (Point3D_F64)poly.get(0));
            this.vb.minus((Point3D_F64)poly.get(2), (Point3D_F64)poly.get(0));
            this.tempN.crossSetTo(this.va, this.vb);
            if (this.tempN.dot(this.normal) < 0.0) {
                this.normal.scale(-1.0);
            }
        }
        if (this.normal.isNaN()) {
            this.errorHandler.handleError(polygonIdx, "Normal has NaN");
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface HandleBadPolygon {
        public void handleError(int var1, String var2);
    }
}

