/*
 * Decompiled with CFR 0.152.
 */
package boofcv.visualize;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.mesh.VertexMesh;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Rectangle2D_I32;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class RenderMesh
implements VerbosePrint {
    public int defaultColorRgba = 0xFFFFFF;
    public SurfaceColor surfaceColor = surface -> 0xFF0000;
    public final GrayF32 depthImage = new GrayF32(1, 1);
    public final InterleavedU8 rgbImage = new InterleavedU8(1, 1, 3);
    public final CameraPinhole intrinsics = new CameraPinhole();
    public final Se3_F64 worldToView = new Se3_F64();
    private final Point3D_F64 camera = new Point3D_F64();
    private final Point2D_F64 point = new Point2D_F64();
    private final Polygon2D_F64 polygon = new Polygon2D_F64();
    final Rectangle2D_I32 aabb = new Rectangle2D_I32();
    @Nullable
    PrintStream verbose = null;

    public void render(VertexMesh mesh) {
        BoofMiscOps.checkTrue((this.intrinsics.width > 0 && this.intrinsics.height > 0 ? 1 : 0) != 0, (String)"Intrinsics not set");
        this.initializeImages();
        int width = this.intrinsics.width;
        int height = this.intrinsics.height;
        double fx = this.intrinsics.fx;
        double fy = this.intrinsics.fy;
        double cx = this.intrinsics.cx;
        double cy = this.intrinsics.cy;
        int shapesRenderedCount = 0;
        for (int shapeIdx = 1; shapeIdx < mesh.offsets.size; ++shapeIdx) {
            int idx1;
            int idx0 = mesh.offsets.get(shapeIdx - 1);
            if (idx0 >= (idx1 = mesh.offsets.get(shapeIdx))) continue;
            this.polygon.vertexes.reset().reserve(idx1 - idx0);
            boolean behindCamera = false;
            for (int i = idx0; i < idx1; ++i) {
                Point3D_F64 world = mesh.vertexes.getTemp(mesh.indexes.get(i));
                this.worldToView.transform(world, this.camera);
                if (this.camera.z <= 0.0) {
                    behindCamera = true;
                    break;
                }
                double normX = this.camera.x / this.camera.z;
                double normY = this.camera.y / this.camera.z;
                double pixelX = normX * fx + cx;
                double pixelY = normY * fy + cy;
                ((Point2D_F64)this.polygon.vertexes.grow()).setTo(pixelX, pixelY);
            }
            if (behindCamera) continue;
            RenderMesh.computeBoundingBox(width, height, this.polygon, this.aabb);
            this.projectSurfaceOntoImage(mesh, this.polygon, shapeIdx - 1);
            ++shapesRenderedCount;
        }
        if (this.verbose != null) {
            this.verbose.println("total shapes rendered: " + shapesRenderedCount);
        }
    }

    void initializeImages() {
        this.depthImage.reshape(this.intrinsics.width, this.intrinsics.height);
        this.rgbImage.reshape(this.intrinsics.width, this.intrinsics.height);
        ImageMiscOps.fill((InterleavedI8)this.rgbImage, (int)this.defaultColorRgba);
        ImageMiscOps.fill((GrayF32)this.depthImage, (float)Float.NaN);
    }

    static void computeBoundingBox(int width, int height, Polygon2D_F64 polygon, Rectangle2D_I32 aabb) {
        UtilPolygons2D_F64.bounding((Polygon2D_F64)polygon, (Rectangle2D_I32)aabb);
        aabb.x0 = Math.max(0, aabb.x0);
        aabb.y0 = Math.max(0, aabb.y0);
        aabb.x1 = Math.min(width, aabb.x1);
        aabb.y1 = Math.min(height, aabb.y1);
    }

    void projectSurfaceOntoImage(VertexMesh mesh, Polygon2D_F64 polygon, int shapeIdx) {
        int vertexIndex = mesh.indexes.get(mesh.offsets.data[shapeIdx]);
        Point3D_F64 world = mesh.vertexes.getTemp(vertexIndex);
        this.worldToView.transform(world, this.camera);
        float depth = (float)this.camera.z;
        int color = this.surfaceColor.surfaceRgb(shapeIdx);
        for (int pixelY = this.aabb.y0; pixelY < this.aabb.y1; ++pixelY) {
            for (int pixelX = this.aabb.x0; pixelX < this.aabb.x1; ++pixelX) {
                float pixelDepth = this.depthImage.unsafe_get(pixelX, pixelY);
                if (!Float.isNaN(pixelDepth) && depth >= pixelDepth) continue;
                this.point.setTo((double)pixelX, (double)pixelY);
                if (!Intersection2D_F64.containsConvex((Polygon2D_F64)polygon, (Point2D_F64)this.point)) continue;
                this.depthImage.unsafe_set(pixelX, pixelY, depth);
                this.rgbImage.set24(pixelX, pixelY, color);
            }
        }
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public int getDefaultColorRgba() {
        return this.defaultColorRgba;
    }

    public void setDefaultColorRgba(int defaultColorRgba) {
        this.defaultColorRgba = defaultColorRgba;
    }

    public SurfaceColor getSurfaceColor() {
        return this.surfaceColor;
    }

    public void setSurfaceColor(SurfaceColor surfaceColor) {
        this.surfaceColor = surfaceColor;
    }

    public GrayF32 getDepthImage() {
        return this.depthImage;
    }

    public InterleavedU8 getRgbImage() {
        return this.rgbImage;
    }

    public CameraPinhole getIntrinsics() {
        return this.intrinsics;
    }

    public Se3_F64 getWorldToView() {
        return this.worldToView;
    }

    @FunctionalInterface
    public static interface SurfaceColor {
        public int surfaceRgb(int var1);
    }
}

