/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.points.impl;

import boofcv.io.points.impl.ObjFileCodec;
import boofcv.io.points.impl.ObjFileReader;
import boofcv.struct.mesh.VertexMesh;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class ObjLoadFromFiles {
    private Map<String, String> materialToTextureFile = new HashMap<String, String>();
    private Map<String, VertexMesh> shapeToMesh = new HashMap<String, VertexMesh>();
    private boolean ignoredMaterial = false;
    private boolean first = true;

    public void load(final File file, final @Nullable VertexMesh outputMesh) {
        this.ignoredMaterial = false;
        this.first = true;
        ObjFileReader reader = new ObjFileReader(){
            VertexMesh active;
            {
                this.active = outputMesh != null ? outputMesh : new VertexMesh();
                this.active.reset();
                ObjLoadFromFiles.this.shapeToMesh.put("", this.active);
            }

            @Override
            protected void addLibrary(String name) {
                ObjLoadFromFiles.this.readTextureFilesFromMTL(new File(file.getParent(), name));
            }

            @Override
            protected void addMaterial(String name) {
                if (ObjLoadFromFiles.this.first && this.active.vertexes.size() == 0) {
                    ObjLoadFromFiles.this.shapeToMesh.remove("");
                }
                if (outputMesh != null) {
                    if (!ObjLoadFromFiles.this.first || this.active.vertexes.size() != 0) {
                        ObjLoadFromFiles.this.ignoredMaterial = true;
                        throw new MultipleMaterials();
                    }
                } else {
                    this.active = new VertexMesh();
                }
                ObjLoadFromFiles.this.first = false;
                if (ObjLoadFromFiles.this.materialToTextureFile.containsKey(name)) {
                    this.active.textureName = ObjLoadFromFiles.this.materialToTextureFile.get(name);
                } else {
                    System.err.println("Unknown material '" + name + "'");
                }
                ObjLoadFromFiles.this.shapeToMesh.put(name, this.active);
            }

            @Override
            protected void addVertex(double x, double y, double z) {
                this.active.vertexes.append(x, y, z);
            }

            @Override
            protected void addVertexWithColor(double x, double y, double z, double red, double green, double blue) {
                this.active.vertexes.append(x, y, z);
                this.active.rgb.add(ObjFileCodec.convertToInt(red, green, blue));
            }

            @Override
            protected void addVertexNormal(double x, double y, double z) {
                this.active.normals.append((float)x, (float)y, (float)z);
            }

            @Override
            protected void addVertexTexture(double x, double y) {
                this.active.texture.append((float)x, (float)y);
            }

            @Override
            protected void addPoint(int vertex) {
            }

            @Override
            protected void addLine(DogArray_I32 vertexes) {
            }

            @Override
            protected void addFace(DogArray_I32 indexes, int vertexCount) {
                ObjFileCodec.addFactToMesh(indexes, vertexCount, this.active);
            }
        };
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            reader.parse(new BufferedReader(input));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (MultipleMaterials e) {
            this.ignoredMaterial = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void readTextureFilesFromMTL(File file) {
        materialName = "";
        try {
            input = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
            try {
                line = input.readLine();
lbl6:
                // 6 sources

                block19: while (line != null) {
                    try {
                        idx1 = line.indexOf(32);
                        if (idx1 == -1) continue;
                        idx2 = line.indexOf(32, idx1 + 1);
                        if (idx2 == -1) {
                            idx2 = line.length();
                        }
                        command = line.substring(0, idx1);
                        value = line.substring(idx1 + 1, idx2);
                        var9_12 = command;
                        var10_13 = -1;
                        switch (var9_12.hashCode()) {
                            case -1048831483: {
                                if (!var9_12.equals("newmtl")) break;
                                var10_13 = 0;
                                break;
                            }
                            case -1081377988: {
                                if (!var9_12.equals("map_Kd")) break;
                                var10_13 = 1;
                            }
                        }
                        switch (var10_13) {
                            case 0: {
                                materialName = value;
                                ** break;
                            }
                            case 1: {
                                this.materialToTextureFile.put(materialName, value);
                                continue block19;
                            }
                            ** default:
lbl34:
                            // 1 sources

                            continue block19;
                        }
                    }
                    finally {
                        line = input.readLine();
                    }
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, VertexMesh> getShapeToMesh() {
        return this.shapeToMesh;
    }

    public boolean isIgnoredMaterial() {
        return this.ignoredMaterial;
    }

    static class MultipleMaterials
    extends RuntimeException {
        MultipleMaterials() {
        }
    }
}

