/*
 * Decompiled with CFR 0.152.
 */
package boofcv.visualize;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.mesh.VertexMesh;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Polygon2D_F32;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Rectangle2D_I32;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class RenderMesh
implements VerbosePrint {
    public int defaultColorRgba = 0xFFFFFF;
    public SurfaceColor surfaceColor = surface -> 0xFF0000;
    public final GrayF32 depthImage = new GrayF32(1, 1);
    public final InterleavedU8 rgbImage = new InterleavedU8(1, 1, 3);
    public final Se3_F64 worldToView = new Se3_F64();
    public boolean checkFaceNormal = false;
    public boolean forceColorizer = false;
    private InterleavedU8 textureImage = new InterleavedU8(1, 1, 3);
    private InterpolatePixelMB<InterleavedU8> textureInterp = FactoryInterpolation.bilinearPixelMB((ImageMultiBand)this.textureImage, (BorderType)BorderType.EXTENDED);
    private float[] textureValues = new float[3];
    protected Point2Transform2_F64 pixelToNorm;
    protected Point2Transform2_F64 normToPixel;
    protected ImageDimension resolution = new ImageDimension();
    private final Point3D_F64 camera = new Point3D_F64();
    private final Point2D_F64 point = new Point2D_F64();
    private final DogArray<Point3D_F64> meshCam = new DogArray(Point3D_F64::new);
    private final Polygon2D_F64 polygonProj = new Polygon2D_F64();
    private final Polygon2D_F32 polygonTex = new Polygon2D_F32();
    final Rectangle2D_I32 aabb = new Rectangle2D_I32();
    private final Polygon2D_F64 workTri = new Polygon2D_F64(3);
    @Nullable
    PrintStream verbose = null;

    public void setTextureImage(InterleavedU8 textureImage) {
        this.textureImage = textureImage;
        this.textureInterp.setImage((ImageBase)textureImage);
        this.textureValues = new float[textureImage.numBands];
    }

    public void setCamera(double hfov, int width, int height) {
        CameraPinhole model = new CameraPinhole();
        PerspectiveOps.createIntrinsic((int)width, (int)height, (double)hfov, (double)-1.0, (CameraPinhole)model);
        LensDistortionPinhole factory = new LensDistortionPinhole(model);
        this.setCamera((LensDistortionNarrowFOV)factory, model.width, model.height);
    }

    public void setCamera(CameraPinholeBrown model) {
        LensDistortionBrown factory = new LensDistortionBrown(model);
        this.setCamera((LensDistortionNarrowFOV)factory, model.width, model.height);
    }

    public void setCamera(LensDistortionNarrowFOV factory, int width, int height) {
        this.setCamera(factory.undistort_F64(true, false), factory.distort_F64(false, true), width, height);
    }

    public void setCamera(Point2Transform2_F64 pixelToNorm, Point2Transform2_F64 normToPixel, int width, int height) {
        this.pixelToNorm = pixelToNorm;
        this.normToPixel = normToPixel;
        this.resolution.setTo(width, height);
    }

    public void render(VertexMesh mesh) {
        BoofMiscOps.checkTrue((this.resolution.width > 0 && this.resolution.height > 0 ? 1 : 0) != 0, (String)"Intrinsics not set");
        if (this.checkFaceNormal && mesh.faceNormals.size() == 0) {
            mesh.computeFaceNormals();
        }
        this.initializeImages();
        int shapesRenderedCount = 0;
        Point3D_F64 worldCamera = new Point3D_F64();
        this.worldToView.transformReverse(worldCamera, worldCamera);
        boolean useColorizer = this.forceColorizer || mesh.texture.size() == 0;
        for (int shapeIdx = 1; shapeIdx < mesh.faceOffsets.size; ++shapeIdx) {
            int idx1;
            int idx0 = mesh.faceOffsets.get(shapeIdx - 1);
            if (idx0 >= (idx1 = mesh.faceOffsets.get(shapeIdx))) continue;
            this.polygonProj.vertexes.reset().reserve(idx1 - idx0);
            this.meshCam.reset().reserve(idx1 - idx0);
            if (!useColorizer) {
                mesh.getTexture(shapeIdx - 1, this.polygonTex.vertexes);
            }
            if (this.checkFaceNormal && !RenderMesh.isFrontVisible(mesh, shapeIdx - 1, idx0, worldCamera)) continue;
            boolean behindCamera = false;
            for (int i = idx0; i < idx1; ++i) {
                Point3D_F64 world = mesh.vertexes.getTemp(mesh.faceVertexes.get(i));
                this.worldToView.transform(world, this.camera);
                if (this.camera.z <= 0.0) {
                    behindCamera = true;
                    break;
                }
                double normX = this.camera.x / this.camera.z;
                double normY = this.camera.y / this.camera.z;
                this.normToPixel.compute(normX, normY, (Point2D_F64)this.polygonProj.vertexes.grow());
                ((Point3D_F64)this.meshCam.grow()).setTo(this.camera);
            }
            if (behindCamera) continue;
            if (useColorizer) {
                this.projectSurfaceColor((FastAccess<Point3D_F64>)this.meshCam, this.polygonProj, shapeIdx - 1);
            } else {
                this.projectSurfaceTexture((FastAccess<Point3D_F64>)this.meshCam, this.polygonProj, this.polygonTex);
            }
            ++shapesRenderedCount;
        }
        if (this.verbose != null) {
            this.verbose.println("total shapes rendered: " + shapesRenderedCount);
        }
    }

    static boolean isFrontVisible(VertexMesh mesh, int shapeIdx, int idx0, Point3D_F64 worldCamera) {
        Point3D_F32 normal = mesh.getFaceNormalTmp(shapeIdx);
        Point3D_F64 v1 = mesh.vertexes.getTemp(mesh.faceVertexes.get(idx0));
        v1.x -= worldCamera.x;
        v1.y -= worldCamera.y;
        v1.z -= worldCamera.z;
        double dot = v1.x * (double)normal.x + v1.y * (double)normal.y + v1.z * (double)normal.z;
        return dot < 0.0;
    }

    void initializeImages() {
        this.depthImage.reshape(this.resolution.width, this.resolution.height);
        this.rgbImage.reshape(this.resolution.width, this.resolution.height);
        ImageMiscOps.fill((InterleavedI8)this.rgbImage, (int)this.defaultColorRgba);
        ImageMiscOps.fill((GrayF32)this.depthImage, (float)Float.NaN);
    }

    static void computeBoundingBox(int width, int height, Polygon2D_F64 polygon, Rectangle2D_I32 aabb) {
        UtilPolygons2D_F64.bounding((Polygon2D_F64)polygon, (Rectangle2D_I32)aabb);
        aabb.x0 = Math.max(0, aabb.x0);
        aabb.y0 = Math.max(0, aabb.y0);
        aabb.x1 = Math.min(width, aabb.x1);
        aabb.y1 = Math.min(height, aabb.y1);
    }

    void projectSurfaceColor(FastAccess<Point3D_F64> mesh, Polygon2D_F64 polyProj, int shapeIdx) {
        float depth = (float)((Point3D_F64)mesh.get((int)0)).z;
        int color = this.surfaceColor.surfaceRgb(shapeIdx);
        RenderMesh.computeBoundingBox(this.resolution.width, this.resolution.height, polyProj, this.aabb);
        for (int pixelY = this.aabb.y0; pixelY < this.aabb.y1; ++pixelY) {
            for (int pixelX = this.aabb.x0; pixelX < this.aabb.x1; ++pixelX) {
                float pixelDepth = this.depthImage.unsafe_get(pixelX, pixelY);
                if (!Float.isNaN(pixelDepth) && depth >= pixelDepth) continue;
                this.point.setTo((double)pixelX, (double)pixelY);
                if (!Intersection2D_F64.containsConvex((Polygon2D_F64)polyProj, (Point2D_F64)this.point)) continue;
                this.depthImage.unsafe_set(pixelX, pixelY, depth);
                this.rgbImage.set24(pixelX, pixelY, color);
            }
        }
    }

    void projectSurfaceTexture(FastAccess<Point3D_F64> mesh, Polygon2D_F64 polyProj, Polygon2D_F32 polyText) {
        float scale = Math.max(this.resolution.width, this.resolution.height);
        for (int vertC = 2; vertC < polyProj.size(); ++vertC) {
            int vertA = 0;
            int vertB = vertC - 1;
            float Z0 = (float)((Point3D_F64)mesh.get((int)vertA)).z;
            float Z1 = (float)((Point3D_F64)mesh.get((int)vertB)).z;
            float Z2 = (float)((Point3D_F64)mesh.get((int)vertC)).z;
            float ax = (float)polyProj.get((int)vertA).x / scale;
            float ay = (float)polyProj.get((int)vertA).y / scale;
            float bx = (float)polyProj.get((int)vertB).x / scale;
            float by = (float)polyProj.get((int)vertB).y / scale;
            float cx = (float)polyProj.get((int)vertC).x / scale;
            float cy = (float)polyProj.get((int)vertC).y / scale;
            float area = RenderMesh.edgeFunction(ax, ay, bx, by, cx, cy);
            Point2D_F32 t0 = polyText.get(vertA);
            Point2D_F32 t1 = polyText.get(vertB);
            Point2D_F32 t2 = polyText.get(vertC);
            this.workTri.get(0).setTo(polyProj.get(vertA));
            this.workTri.get(1).setTo(polyProj.get(vertB));
            this.workTri.get(2).setTo(polyProj.get(vertC));
            RenderMesh.computeBoundingBox(this.resolution.width, this.resolution.height, this.workTri, this.aabb);
            for (int pixelY = this.aabb.y0; pixelY < this.aabb.y1; ++pixelY) {
                float py = (float)pixelY / scale;
                for (int pixelX = this.aabb.x0; pixelX < this.aabb.x1; ++pixelX) {
                    float px = (float)pixelX / scale;
                    this.point.setTo((double)pixelX, (double)pixelY);
                    if (!Intersection2D_F64.containsConvex((Polygon2D_F64)this.workTri, (Point2D_F64)this.point)) continue;
                    float pixelDepth = this.depthImage.unsafe_get(pixelX, pixelY);
                    float alpha = RenderMesh.edgeFunction(bx, by, cx, cy, px, py) / area;
                    float beta = RenderMesh.edgeFunction(cx, cy, ax, ay, px, py) / area;
                    float gamma = RenderMesh.edgeFunction(ax, ay, bx, by, px, py) / area;
                    float depth = alpha * Z0 + beta * Z1 + gamma * Z2;
                    if (!Float.isNaN(pixelDepth) && depth >= pixelDepth) continue;
                    float oneOverW = alpha / Z0 + beta / Z1 + gamma / Z2;
                    float u = (alpha * t0.x / Z0 + beta * t1.x / Z1 + gamma * t2.x / Z2) / oneOverW;
                    float v = (alpha * t0.y / Z0 + beta * t1.y / Z1 + gamma * t2.y / Z2) / oneOverW;
                    float pixTexX = u * (float)(this.textureImage.width - 1);
                    float pixTexY = (1.0f - v) * (float)(this.textureImage.height - 1);
                    int color = this.interpolateTextureRgb(pixTexX, pixTexY);
                    this.depthImage.unsafe_set(pixelX, pixelY, depth);
                    this.rgbImage.set24(pixelX, pixelY, color);
                }
            }
        }
    }

    private static float edgeFunction(float x0, float y0, float x1, float y1, float x2, float y2) {
        return (x2 - x0) * (y1 - y0) - (y2 - y0) * (x1 - x0);
    }

    int interpolateTextureRgb(float px, float py) {
        this.textureInterp.get(px, py, this.textureValues);
        int r = (int)(this.textureValues[0] + 0.5f);
        int g = (int)(this.textureValues[1] + 0.5f);
        int b = (int)(this.textureValues[2] + 0.5f);
        return r << 16 | g << 8 | b;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public int getDefaultColorRgba() {
        return this.defaultColorRgba;
    }

    public void setDefaultColorRgba(int defaultColorRgba) {
        this.defaultColorRgba = defaultColorRgba;
    }

    public SurfaceColor getSurfaceColor() {
        return this.surfaceColor;
    }

    public void setSurfaceColor(SurfaceColor surfaceColor) {
        this.surfaceColor = surfaceColor;
    }

    public GrayF32 getDepthImage() {
        return this.depthImage;
    }

    public InterleavedU8 getRgbImage() {
        return this.rgbImage;
    }

    public Se3_F64 getWorldToView() {
        return this.worldToView;
    }

    public boolean isCheckFaceNormal() {
        return this.checkFaceNormal;
    }

    public void setCheckFaceNormal(boolean checkFaceNormal) {
        this.checkFaceNormal = checkFaceNormal;
    }

    public boolean isForceColorizer() {
        return this.forceColorizer;
    }

    public void setForceColorizer(boolean forceColorizer) {
        this.forceColorizer = forceColorizer;
    }

    @FunctionalInterface
    public static interface SurfaceColor {
        public int surfaceRgb(int var1);
    }
}

