/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.select;

import boofcv.alg.disparity.block.score.DisparitySparseRectifiedScoreBM;
import boofcv.alg.disparity.block.select.SelectSparseErrorWithChecksWta_F32;
import boofcv.alg.disparity.block.select.SelectSparseErrorWithChecksWta_S32;

public class SelectSparseErrorSubpixel {

    public static class F32
    extends SelectSparseErrorWithChecksWta_F32 {
        final boolean squaredError;

        public F32(int maxError, double texture, int tolRightToLeft, boolean squaredError) {
            super(maxError, texture, tolRightToLeft);
            this.squaredError = squaredError;
        }

        @Override
        public boolean select(DisparitySparseRectifiedScoreBM<float[], ?> scorer, int x, int y) {
            if (super.select(scorer, x, y)) {
                int disparityRange = scorer.getLocalRangeLtoR();
                float[] scores = scorer.getScoreLtoR();
                int disparityValue = (int)this.disparity;
                if (disparityValue == 0 || disparityValue == disparityRange - 1) {
                    return true;
                }
                float c0 = scores[disparityValue - 1];
                float c1 = scores[disparityValue];
                float c2 = scores[disparityValue + 1];
                if (!this.squaredError) {
                    c0 *= c0;
                    c1 *= c1;
                    c2 *= c2;
                }
                float offset = (c0 - c2) / (2.0f * (c0 - 2.0f * c1 + c2));
                this.disparity += (double)offset;
                return true;
            }
            return false;
        }
    }

    public static class S32
    extends SelectSparseErrorWithChecksWta_S32 {
        final boolean squaredError;

        public S32(int maxError, double texture, int tolRightToLeft, boolean squaredError) {
            super(maxError, texture, tolRightToLeft);
            this.squaredError = squaredError;
        }

        @Override
        public boolean select(DisparitySparseRectifiedScoreBM<int[], ?> scorer, int x, int y) {
            if (super.select(scorer, x, y)) {
                int disparityRange = scorer.getLocalRangeLtoR();
                int[] scores = scorer.getScoreLtoR();
                int disparityValue = (int)this.disparity;
                if (disparityValue == 0 || disparityValue == disparityRange - 1) {
                    return true;
                }
                double c0 = scores[disparityValue - 1];
                double c1 = scores[disparityValue];
                double c2 = scores[disparityValue + 1];
                if (!this.squaredError) {
                    c0 *= c0;
                    c1 *= c1;
                    c2 *= c2;
                }
                double offset = (c0 - c2) / (2.0 * (c0 - 2.0 * c1 + c2));
                this.disparity += offset;
                return true;
            }
            return false;
        }
    }
}

