/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.sgm;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.disparity.sgm.SgmDisparityCost;
import boofcv.alg.disparity.sgm.SgmDisparitySelector;
import boofcv.alg.disparity.sgm.SgmStereoDisparity;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class SgmStereoDisparityCensus<T extends ImageBase<T>, C extends ImageGray<C>>
extends SgmStereoDisparity<T, C> {
    FilterImageInterface<T, C> censusTran;
    C cleft;
    C cright;

    public SgmStereoDisparityCensus(FilterImageInterface<T, C> censusTran, SgmDisparityCost<C> sgmCost, SgmDisparitySelector selector) {
        super(sgmCost, selector);
        this.censusTran = censusTran;
        this.cleft = (ImageGray)censusTran.getOutputType().createImage(1, 1);
        this.cright = (ImageGray)censusTran.getOutputType().createImage(1, 1);
    }

    @Override
    public void process(T left, T right) {
        InputSanityCheck.checkSameShape(left, right);
        this.censusTran.process(left, this.cleft);
        this.censusTran.process(right, this.cright);
        this.disparity.reshape(left);
        this.helper.configure(((ImageBase)left).width, this.disparityMin, this.disparityRange);
        this.sgmCost.configure(this.disparityMin, this.disparityRange);
        this.aggregation.configure(this.disparityMin);
        this.sgmCost.process(this.cleft, this.cright, (Planar<GrayU16>)this.costYXD);
        this.aggregation.process((Planar<GrayU16>)this.costYXD);
        this.selector.setDisparityMin(this.disparityMin);
        this.selector.select((Planar<GrayU16>)this.costYXD, this.aggregation.getAggregated(), this.disparity);
    }
}

