/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.denoise;

import boofcv.abst.denoise.WaveletDenoiseFilter;
import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.factory.denoise.FactoryDenoiseWaveletAlg;
import boofcv.factory.transform.wavelet.FactoryWaveletDaub;
import boofcv.factory.transform.wavelet.FactoryWaveletTransform;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class FactoryImageDenoise {
    public static <T extends ImageGray<T>> WaveletDenoiseFilter<T> waveletVisu(Class<T> imageType, int numLevels, double minPixelValue, double maxPixelValue) {
        ImageDataType info = ImageDataType.classToType(imageType);
        WaveletTransform descTran = FactoryImageDenoise.createDefaultShrinkTransform(info, numLevels, minPixelValue, maxPixelValue);
        DenoiseWavelet<T> denoiser = FactoryDenoiseWaveletAlg.visu(imageType);
        return new WaveletDenoiseFilter(descTran, denoiser);
    }

    public static <T extends ImageGray<T>> WaveletDenoiseFilter<T> waveletBayes(Class<T> imageType, int numLevels, double minPixelValue, double maxPixelValue) {
        ImageDataType info = ImageDataType.classToType(imageType);
        WaveletTransform descTran = FactoryImageDenoise.createDefaultShrinkTransform(info, numLevels, minPixelValue, maxPixelValue);
        DenoiseWavelet<T> denoiser = FactoryDenoiseWaveletAlg.bayes(null, imageType);
        return new WaveletDenoiseFilter(descTran, denoiser);
    }

    public static <T extends ImageGray<T>> WaveletDenoiseFilter<T> waveletSure(Class<T> imageType, int numLevels, double minPixelValue, double maxPixelValue) {
        ImageDataType info = ImageDataType.classToType(imageType);
        WaveletTransform descTran = FactoryImageDenoise.createDefaultShrinkTransform(info, numLevels, minPixelValue, maxPixelValue);
        DenoiseWavelet<T> denoiser = FactoryDenoiseWaveletAlg.sure(imageType);
        return new WaveletDenoiseFilter(descTran, denoiser);
    }

    private static WaveletTransform createDefaultShrinkTransform(ImageDataType imageType, int numLevels, double minPixelValue, double maxPixelValue) {
        WaveletTransform<Object, Object, Object> descTran;
        if (!imageType.isInteger()) {
            WaveletDescription<WlCoef_F32> waveletDesc_F32 = FactoryWaveletDaub.daubJ_F32(4);
            descTran = FactoryWaveletTransform.create_F32(waveletDesc_F32, numLevels, (float)minPixelValue, (float)maxPixelValue);
        } else {
            WaveletDescription<WlCoef_I32> waveletDesc_I32 = FactoryWaveletDaub.biorthogonal_I32(5, BorderType.REFLECT);
            descTran = FactoryWaveletTransform.create_I(waveletDesc_I32, numLevels, (int)minPixelValue, (int)maxPixelValue, ImageType.getImageClass((ImageType.Family)ImageType.Family.GRAY, (ImageDataType)imageType));
        }
        return descTran;
    }
}

