/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class GenericConvolve<Input extends ImageBase<Input>, Output extends ImageBase<Output>>
implements ConvolveInterface<Input, Output> {
    Method m;
    KernelBase kernel;
    BorderType type;
    @Nullable
    ImageBorder borderRule;
    ImageType<Input> inputType;
    ImageType<Output> outputType;

    public GenericConvolve(Method m, KernelBase kernel, BorderType type, ImageType<Input> inputType, ImageType<Output> outputType) {
        this.m = m;
        this.kernel = kernel;
        this.type = type;
        this.inputType = inputType;
        this.outputType = outputType;
        Class<?>[] params = m.getParameterTypes();
        this.borderRule = type == BorderType.SKIP || type == BorderType.NORMALIZED ? null : FactoryImageBorder.single(type, params[1]);
    }

    @Override
    public void process(Input input, Output output) {
        try {
            if (this.kernel.getDimension() == 1) {
                switch (this.type) {
                    case SKIP: 
                    case NORMALIZED: {
                        this.m.invoke(null, this.kernel, input, output);
                        break;
                    }
                    default: {
                        this.m.invoke(null, this.kernel, input, output, Objects.requireNonNull(this.borderRule));
                        break;
                    }
                }
            } else {
                switch (this.type) {
                    case SKIP: 
                    case NORMALIZED: {
                        this.m.invoke(null, this.kernel, input, output);
                        break;
                    }
                    default: {
                        this.m.invoke(null, this.kernel, input, output, Objects.requireNonNull(this.borderRule));
                    }
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getBorderX() {
        if (this.type == BorderType.SKIP) {
            return this.kernel.getRadius();
        }
        return 0;
    }

    @Override
    public BorderType getBorderType() {
        return this.type;
    }

    @Override
    public int getBorderY() {
        return this.getBorderX();
    }

    @Override
    public ImageType<Input> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<Output> getOutputType() {
        return this.outputType;
    }
}

