/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color.impl;

import boofcv.alg.color.ColorLab;
import boofcv.alg.color.ColorXyz;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class ImplColorLab {
    public static void rgbToLab_U8(Planar<GrayU8> rgb, Planar<GrayF32> lab) {
        GrayU8 R = (GrayU8)rgb.getBand(0);
        GrayU8 G = (GrayU8)rgb.getBand(1);
        GrayU8 B = (GrayU8)rgb.getBand(2);
        GrayF32 L_ = (GrayF32)lab.getBand(0);
        GrayF32 A_ = (GrayF32)lab.getBand(1);
        GrayF32 B_ = (GrayF32)lab.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float r = ColorXyz.table_invgamma_f[R.data[indexRgb] & 0xFF];
                float g = ColorXyz.table_invgamma_f[G.data[indexRgb] & 0xFF];
                float b = ColorXyz.table_invgamma_f[B.data[indexRgb] & 0xFF];
                float X = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                float Y = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                float Z = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                float xr = X / 0.950456f;
                float yr = Y / 1.0f;
                float zr = Z / 1.088754f;
                float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
                float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
                float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
                L_.data[indexLab] = 116.0f * fy - 16.0f;
                A_.data[indexLab] = 500.0f * (fx - fy);
                B_.data[indexLab] = 200.0f * (fy - fz);
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }

    public static void rgbToLab_F32(Planar<GrayF32> rgb, Planar<GrayF32> lab) {
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        GrayF32 L_ = (GrayF32)lab.getBand(0);
        GrayF32 A_ = (GrayF32)lab.getBand(1);
        GrayF32 B_ = (GrayF32)lab.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float r = (float)ColorXyz.invGamma(R.data[indexRgb] / 255.0f);
                float g = (float)ColorXyz.invGamma(G.data[indexRgb] / 255.0f);
                float b = (float)ColorXyz.invGamma(B.data[indexRgb] / 255.0f);
                float X = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                float Y = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                float Z = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                float xr = X / 0.950456f;
                float yr = Y / 1.0f;
                float zr = Z / 1.088754f;
                float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
                float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
                float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
                L_.data[indexLab] = 116.0f * fy - 16.0f;
                A_.data[indexLab] = 500.0f * (fx - fy);
                B_.data[indexLab] = 200.0f * (fy - fz);
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }

    public static void labToRgb_F32(Planar<GrayF32> lab, Planar<GrayF32> rgb) {
        rgb.reshapeTo(lab);
        GrayF32 L = (GrayF32)lab.getBand(0);
        GrayF32 A = (GrayF32)lab.getBand(1);
        GrayF32 BB = (GrayF32)lab.getBand(2);
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float l = L.data[indexLab];
                float a = A.data[indexLab];
                float b = BB.data[indexLab];
                float left = (l + 16.0f) / 116.0f;
                float x = 0.950456f * ColorLab.invTran(left + a / 500.0f);
                float y = 1.0f * ColorLab.invTran(left);
                float z = 1.088754f * ColorLab.invTran(left - b / 200.0f);
                R.data[indexRgb] = (float)(255.0 * ColorXyz.gamma(3.240479f * x - 1.53715f * y - 0.498535f * z));
                G.data[indexRgb] = (float)(255.0 * ColorXyz.gamma(-0.969256f * x + 1.875991f * y + 0.041556f * z));
                B.data[indexRgb] = (float)(255.0 * ColorXyz.gamma(0.055648f * x - 0.204043f * y + 1.057311f * z));
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }

    public static void labToRgb_U8(Planar<GrayF32> lab, Planar<GrayU8> rgb) {
        rgb.reshapeTo(lab);
        GrayF32 L = (GrayF32)lab.getBand(0);
        GrayF32 A = (GrayF32)lab.getBand(1);
        GrayF32 BB = (GrayF32)lab.getBand(2);
        GrayU8 R = (GrayU8)rgb.getBand(0);
        GrayU8 G = (GrayU8)rgb.getBand(1);
        GrayU8 B = (GrayU8)rgb.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float l = L.data[indexLab];
                float a = A.data[indexLab];
                float b = BB.data[indexLab];
                float left = (l + 16.0f) / 116.0f;
                float x = 0.950456f * ColorLab.invTran(left + a / 500.0f);
                float y = 1.0f * ColorLab.invTran(left);
                float z = 1.088754f * ColorLab.invTran(left - b / 200.0f);
                R.data[indexRgb] = (byte)(255.0 * ColorXyz.gamma(3.240479f * x - 1.53715f * y - 0.498535f * z) + 0.5);
                G.data[indexRgb] = (byte)(255.0 * ColorXyz.gamma(-0.969256f * x + 1.875991f * y + 0.041556f * z) + 0.5);
                B.data[indexRgb] = (byte)(255.0 * ColorXyz.gamma(0.055648f * x - 0.204043f * y + 1.057311f * z) + 0.5);
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }
}

