/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.aztec.AztecDecoder;
import boofcv.alg.fiducial.aztec.AztecGenerator;
import boofcv.alg.fiducial.aztec.AztecMessageModeCodec;
import boofcv.alg.fiducial.aztec.AztecPyramid;
import boofcv.alg.fiducial.aztec.GridToPixelHelper;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCodeDecoderImage;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.packed.PackedArrayPoint2D_I16;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.Matrix;
import org.jetbrains.annotations.Nullable;

public class AztecDecoderImage<T extends ImageGray<T>>
implements VerbosePrint {
    protected InterpolatePixelS<T> interpolate;
    public int maxOrientationError = 4;
    public boolean considerTransposed = true;
    @Nullable
    PrintStream verbose = null;
    static final int[] modeBitTypesFull = new int[]{1, 1, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 0, 1, 1, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 1, 0, 0, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 1};
    static final int[] modeBitTypesComp = new int[]{1, 1, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 1};
    AztecDecoder decodeMessage = new AztecDecoder();
    AztecMessageModeCodec decoderMode = new AztecMessageModeCodec();
    PackedArrayPoint2D_I16 coordinates = new PackedArrayPoint2D_I16();
    Point2D_I16 coordinate = new Point2D_I16();
    PackedBits8 imageBits = new PackedBits8();
    PackedBits8 bits = new PackedBits8();
    GridToPixelHelper gridToPixel = new GridToPixelHelper();
    Point2D_F64 pixel = new Point2D_F64();

    public AztecDecoderImage(Class<T> imageType) {
        this.interpolate = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (InterpolationType)InterpolationType.NEAREST_NEIGHBOR, (BorderType)BorderType.EXTENDED, imageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(AztecPyramid locatorPattern, T gray, AztecCode marker) {
        marker.reset();
        this.interpolate.setImage(gray);
        if (!this.decodeMode(locatorPattern, marker)) {
            return false;
        }
        try {
            if (!this.decodeMessage(marker)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            double r = (double)marker.getMarkerWidthSquares() / 2.0;
            this.gridToPixel.convert(-r, -r, marker.bounds.get(0));
            this.gridToPixel.convert(r, -r, marker.bounds.get(1));
            this.gridToPixel.convert(r, r, marker.bounds.get(2));
            this.gridToPixel.convert(-r, r, marker.bounds.get(3));
            marker.Hinv.setTo((Matrix)this.gridToPixel.gridToImage);
        }
        if (!UtilPolygons2D_F64.isConvex((Polygon2D_F64)marker.bounds)) {
            marker.failure = AztecCode.Failure.IMPROBABLE;
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("success decoding!");
        }
        return true;
    }

    protected boolean decodeMode(AztecPyramid locator, AztecCode marker) {
        marker.locator.setTo(locator);
        AztecCode.Structure type = locator.layers.size == 1 ? AztecCode.Structure.COMPACT : AztecCode.Structure.FULL;
        this.readModeBitsFromImage(locator);
        int orientation = this.selectOrientationAndTranspose(type);
        if (orientation < 0) {
            marker.failure = AztecCode.Failure.ORIENTATION;
            if (this.verbose != null) {
                this.verbose.println("failed to find a valid orientation");
            }
            return false;
        }
        boolean bl = marker.transposed = orientation >= 4;
        if (marker.transposed) {
            orientation -= 4;
            AztecDecoderImage.transposeModeBitArray(this.imageBits, this.bits);
        }
        this.extractModeDataBits(orientation, type);
        for (int i = 0; i < orientation; ++i) {
            for (int layerIdx = 0; layerIdx < marker.locator.layers.size; ++layerIdx) {
                if (marker.transposed) {
                    UtilPolygons2D_F64.shiftDown((Polygon2D_F64)((AztecPyramid.Layer)marker.locator.layers.get((int)layerIdx)).square);
                    continue;
                }
                UtilPolygons2D_F64.shiftUp((Polygon2D_F64)((AztecPyramid.Layer)marker.locator.layers.get((int)layerIdx)).square);
            }
        }
        marker.structure = type;
        if (!this.decoderMode.decodeMode(this.bits, marker)) {
            marker.failure = AztecCode.Failure.MODE_ECC;
            if (this.verbose != null) {
                this.verbose.println("error correction failed when decoding mode");
            }
            return false;
        }
        if (marker.messageWordCount > marker.getCapacityWords()) {
            if (this.verbose != null) {
                this.verbose.println("number of message words exceeds marker capacity");
            }
            return false;
        }
        return true;
    }

    static int transposeModeBitIndex(int index, int size) {
        return (size - index) % size;
    }

    static void transposeModeBitArray(PackedBits8 bits, PackedBits8 work) {
        work.setTo(bits);
        for (int i = 0; i < bits.size; ++i) {
            bits.set(AztecDecoderImage.transposeModeBitIndex(i, bits.size), work.get(i));
        }
    }

    void readModeBitsFromImage(AztecPyramid locator) {
        AztecPyramid.Layer layer = (AztecPyramid.Layer)locator.layers.get(0);
        int modeGridWidth = locator.layers.size == 2 ? 15 : 11;
        this.gridToPixel.initOriginCenter(layer.square, modeGridWidth - 6);
        float threshold = (float)layer.threshold;
        int radius = modeGridWidth / 2;
        this.imageBits.resize(0);
        this.readBitsRow(-radius, -radius, 1, 0, modeGridWidth - 1, threshold);
        this.readBitsRow(radius, -radius, 0, 1, modeGridWidth - 1, threshold);
        this.readBitsRow(radius, radius, -1, 0, modeGridWidth - 1, threshold);
        this.readBitsRow(-radius, radius, 0, -1, modeGridWidth - 1, threshold);
    }

    void readBitsRow(int x0, int y0, int dx, int dy, int total, float threshold) {
        int readBits = 0;
        for (int i = 0; i < total; ++i) {
            double x = x0 + i * dx;
            double y = y0 + i * dy;
            this.gridToPixel.convert(x, y, this.pixel);
            float value = this.interpolate.get((float)this.pixel.x, (float)this.pixel.y);
            if (!(value < threshold)) continue;
            readBits |= 1 << i;
        }
        this.imageBits.append(readBits, total, true);
    }

    int selectOrientationAndTranspose(AztecCode.Structure type) {
        int[] modeBitTypes = AztecDecoderImage.getModeBitType(type);
        int width = modeBitTypes.length / 4;
        int bestOrientation = -1;
        boolean bestTranspose = false;
        int bestErrors = this.maxOrientationError;
        for (int tran = 0; tran < 2; ++tran) {
            boolean transposed = tran == 1;
            for (int ori = 0; ori < 4; ++ori) {
                int errors = this.fixedFeatureReadErrors(transposed, ori * width, modeBitTypes);
                if (errors >= bestErrors) continue;
                bestErrors = errors;
                bestOrientation = ori;
                bestTranspose = transposed;
            }
        }
        return bestOrientation + (bestTranspose ? 4 : 0);
    }

    void extractModeDataBits(int orientation, AztecCode.Structure type) {
        int[] modeBitTypes = AztecDecoderImage.getModeBitType(type);
        int offset = orientation * modeBitTypes.length / 4;
        this.bits.resize(0);
        for (int i = 0; i < modeBitTypes.length; ++i) {
            if (modeBitTypes[i] != 2) continue;
            int index = (i + offset) % modeBitTypes.length;
            this.bits.append(this.imageBits.get(index), 1, false);
        }
    }

    static int[] getModeBitType(AztecCode.Structure type) {
        return type == AztecCode.Structure.COMPACT ? modeBitTypesComp : modeBitTypesFull;
    }

    int fixedFeatureReadErrors(boolean transposed, int offset, int[] modeBitTypes) {
        BoofMiscOps.checkEq((int)modeBitTypes.length, (int)this.imageBits.size);
        int errors = 0;
        for (int i = 0; i < modeBitTypes.length; ++i) {
            int adjustedIndex;
            int type = modeBitTypes[i];
            if (type == 2) continue;
            int index = (i + offset) % modeBitTypes.length;
            int n = adjustedIndex = transposed ? AztecDecoderImage.transposeModeBitIndex(index, this.imageBits.size) : index;
            if (this.imageBits.get(adjustedIndex) == type) continue;
            ++errors;
        }
        return errors;
    }

    protected boolean decodeMessage(AztecCode marker) {
        AztecGenerator.computeDataBitCoordinates(marker, this.coordinates);
        this.readMessageDataFromImage(marker);
        marker.rawbits = new byte[this.bits.arrayLength()];
        System.arraycopy(this.bits.data, 0, marker.rawbits, 0, marker.rawbits.length);
        if (!this.decodeMessage.process(marker)) {
            marker.failure = this.decodeMessage.failedECC ? AztecCode.Failure.MESSAGE_ECC : AztecCode.Failure.MESSAGE_PARSE;
            if (this.verbose != null) {
                this.verbose.println("Could not decode the message. ecc=" + this.decodeMessage.failedECC);
            }
            return false;
        }
        return true;
    }

    void readMessageDataFromImage(AztecCode marker) {
        int bitIdx;
        int modeGridWidth = marker.locator.getGridWidth();
        AztecPyramid.Layer locator = (AztecPyramid.Layer)marker.locator.layers.get(0);
        if (marker.transposed) {
            QrCodeDecoderImage.transposeCorners(locator.square);
        }
        this.gridToPixel.initOriginCenter(locator.square, modeGridWidth - 6);
        if (marker.transposed) {
            QrCodeDecoderImage.transposeCorners(locator.square);
        }
        float threshold = (float)locator.threshold;
        this.bits.resize(0);
        for (bitIdx = marker.getCapacityBits() - 1; bitIdx >= 8; bitIdx -= 8) {
            int data = 0;
            for (int i = 0; i < 8; ++i) {
                this.coordinates.getCopy(bitIdx - i, this.coordinate);
                this.gridToPixel.convert(this.coordinate.x, this.coordinate.y, this.pixel);
                float value = this.interpolate.get((float)this.pixel.x, (float)this.pixel.y);
                if (!(value < threshold)) continue;
                data |= 1 << i;
            }
            this.bits.append(data, 8, true);
        }
        while (bitIdx >= 0) {
            this.coordinates.getCopy(bitIdx--, this.coordinate);
            this.gridToPixel.convert(this.coordinate.x, this.coordinate.y, this.pixel);
            float value = this.interpolate.get((float)this.pixel.x, (float)this.pixel.y);
            this.bits.append(value < threshold ? 1 : 0, 1, true);
        }
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.decodeMessage});
    }

    public InterpolatePixelS<T> getInterpolate() {
        return this.interpolate;
    }
}

