/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;

public class GridToPixelHelper {
    protected Estimate1ofEpipolar computeH = FactoryMultiView.homographyTLS();
    protected DMatrixRMaj gridToImage = new DMatrixRMaj(3, 3);
    protected DogArray<AssociatedPair> pairs = new DogArray(AssociatedPair::new, AssociatedPair::zero);
    protected Point2D_F64 gridPoint = new Point2D_F64();

    public void initOriginCenter(Polygon2D_F64 polygon, int squaresWide) {
        double r = (double)squaresWide / 2.0;
        this.pairs.reset().resize(4);
        ((AssociatedPair)this.pairs.get(0)).setTo(-r, -r, polygon.get(0));
        ((AssociatedPair)this.pairs.get(1)).setTo(r, -r, polygon.get(1));
        ((AssociatedPair)this.pairs.get(2)).setTo(r, r, polygon.get(2));
        ((AssociatedPair)this.pairs.get(3)).setTo(-r, r, polygon.get(3));
        this.computeH.process(this.pairs.toList(), (Object)this.gridToImage);
    }

    public void convert(double gridX, double gridY, Point2D_F64 pixel) {
        this.gridPoint.setTo(gridX, gridY);
        GeometryMath_F64.mult((DMatrixRMaj)this.gridToImage, (GeoTuple2D_F64)this.gridPoint, (GeoTuple2D_F64)pixel);
    }
}

