/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene.nister2006;

import boofcv.alg.scene.vocabtree.HierarchicalVocabularyTree;
import boofcv.errors.BoofCheckFailure;
import boofcv.misc.BoofLambdas;
import boofcv.struct.ConfigLength;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;

public class LearnNodeWeights<Point> {
    protected HierarchicalVocabularyTree<Point> tree;
    public ConfigLength maximumNumberImagesInNode = ConfigLength.relative((double)1.0, (double)1.0);
    public boolean checkEveryNodeSeenOnce = false;
    DogArray_I32 numberOfImagesWithNode = new DogArray_I32();
    TIntSet nodesInImage = new TIntHashSet();
    int totalImages;

    public void reset(HierarchicalVocabularyTree<Point> tree) {
        this.tree = tree;
        this.numberOfImagesWithNode.reset().resize(tree.nodes.size, 0);
        this.totalImages = 0;
    }

    public void addImage(List<Point> descriptors) {
        ++this.totalImages;
        this.nodesInImage.clear();
        for (int descIdx = 0; descIdx < descriptors.size(); ++descIdx) {
            this.tree.searchPathToLeaf(descriptors.get(descIdx), (BoofLambdas.ProcessIndex<HierarchicalVocabularyTree.Node>)((BoofLambdas.ProcessIndex)(depth, node) -> this.nodesInImage.add(node.index)));
        }
        for (int n : this.nodesInImage) {
            this.numberOfImagesWithNode.data[n] = this.numberOfImagesWithNode.data[n] + 1;
        }
    }

    public void fixate() {
        ((HierarchicalVocabularyTree.Node)this.tree.nodes.get((int)0)).weight = 0.0;
        int maxImagesInNode = this.maximumNumberImagesInNode.computeI((double)this.totalImages);
        for (int i = 1; i < this.tree.nodes.size; ++i) {
            HierarchicalVocabularyTree.Node n = (HierarchicalVocabularyTree.Node)this.tree.nodes.get(i);
            int totalImagesFoundInsideOf = this.numberOfImagesWithNode.get(n.index);
            if (totalImagesFoundInsideOf > maxImagesInNode) {
                n.weight = 0.0;
                continue;
            }
            if (totalImagesFoundInsideOf == 0) {
                if (this.checkEveryNodeSeenOnce) {
                    throw new BoofCheckFailure("Every node should have been seen by at least 1 image if feed the same images the tree was trained from.");
                }
                n.weight = 0.0;
                continue;
            }
            n.weight = Math.log((double)this.totalImages / (double)totalImagesFoundInsideOf);
        }
    }

    public HierarchicalVocabularyTree<Point> getTree() {
        return this.tree;
    }
}

