/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.ScoreIndex;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public abstract class ReconstructionFromPairwiseGraph
implements VerbosePrint {
    public final ConfigLength maximumSeedFailures = ConfigLength.relative((double)0.1, (double)10.0);
    protected PairwiseGraphUtils utils;
    @Nullable
    protected PrintStream verbose;
    public DogArray<ScoreIndex> scoresMotions = new DogArray(ScoreIndex::new);
    DogArray<SeedInfo> seedScores = new DogArray(SeedInfo::new, SeedInfo::reset);
    private final List<PairwiseImageGraph.View> valid = new ArrayList<PairwiseImageGraph.View>();

    protected ReconstructionFromPairwiseGraph(PairwiseGraphUtils utils) {
        this.utils = utils;
    }

    protected void findAllOpenViews(SceneWorkingGraph scene) {
        for (SceneWorkingGraph.View wview : scene.getAllViews()) {
            this.addOpenForView(scene, wview.pview);
        }
    }

    protected void addOpenForView(SceneWorkingGraph scene, PairwiseImageGraph.View view) {
        int openSizeBefore = scene.open.size;
        for (int connIdx = 0; connIdx < view.connections.size; ++connIdx) {
            PairwiseImageGraph.Motion c = (PairwiseImageGraph.Motion)view.connections.get(connIdx);
            if (!c.is3D) continue;
            PairwiseImageGraph.View o = c.other(view);
            if (scene.exploredViews.contains(o.id)) continue;
            scene.open.add((Object)o);
            scene.exploredViews.add(o.id);
        }
        if (this.verbose == null) {
            return;
        }
        this.verbose.print("_ scene[" + scene.index + "].view='" + view.id + "' adding: size=" + (scene.open.size - openSizeBefore) + " views={ ");
        for (int i = openSizeBefore; i < scene.open.size; ++i) {
            this.verbose.print("'" + ((PairwiseImageGraph.View)scene.open.get((int)i)).id + "' ");
        }
        this.verbose.println("}");
    }

    protected boolean selectNextToProcess(SceneWorkingGraph scene, Expansion selection) {
        selection.reset();
        selection.scene = scene;
        int bestIdx = -1;
        double bestScore = 0.0;
        int bestValidCount = 0;
        this.valid.clear();
        for (int openIdx = 0; openIdx < scene.open.size; ++openIdx) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)scene.open.get(openIdx);
            this.valid.clear();
            for (int connIdx = 0; connIdx < pview.connections.size; ++connIdx) {
                PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)pview.connections.get(connIdx);
                PairwiseImageGraph.View dst = m.other(pview);
                if (!m.is3D || !scene.isKnown(dst)) continue;
                this.valid.add(dst);
            }
            double bestLocalScore = 0.0;
            for (int idx0 = 0; idx0 < this.valid.size(); ++idx0) {
                PairwiseImageGraph.View viewB = this.valid.get(idx0);
                PairwiseImageGraph.Motion m0 = Objects.requireNonNull(pview.findMotion(viewB));
                for (int idx1 = idx0 + 1; idx1 < this.valid.size(); ++idx1) {
                    PairwiseImageGraph.View viewC = this.valid.get(idx1);
                    PairwiseImageGraph.Motion m2 = viewB.findMotion(viewC);
                    if (m2 == null || !m2.is3D) continue;
                    PairwiseImageGraph.Motion m1 = Objects.requireNonNull(pview.findMotion(viewC));
                    double s = BoofMiscOps.min((double)m0.score3D, (double)m1.score3D, (double)m2.score3D);
                    bestLocalScore = Math.max(s, bestLocalScore);
                }
            }
            if (Math.min(3, this.valid.size()) < bestValidCount || !(bestLocalScore > bestScore)) continue;
            bestValidCount = Math.min(3, this.valid.size());
            bestScore = bestLocalScore;
            bestIdx = openIdx;
        }
        if (bestIdx < 0) {
            if (this.verbose != null) {
                this.verbose.println("_ Failed to find a valid view to connect. open.size=" + scene.open.size);
                for (int i = 0; i < scene.open.size; ++i) {
                    PairwiseImageGraph.View v = (PairwiseImageGraph.View)scene.open.get(i);
                    this.verbose.print("___ id='" + v.id + "' conn={ ");
                    for (int j = 0; j < v.connections.size; ++j) {
                        this.verbose.print("'" + ((PairwiseImageGraph.Motion)v.connections.get((int)j)).other((PairwiseImageGraph.View)v).id + "' ");
                    }
                    this.verbose.println("}");
                }
            }
            return false;
        }
        if (this.verbose != null) {
            this.verbose.printf("_ scene[%d].open.size=%d score=%.2f conn=%d\n", scene.index, scene.open.size, bestScore, bestValidCount);
        }
        selection.score = bestScore;
        selection.openIdx = bestIdx;
        return true;
    }

    protected Map<String, SeedInfo> scoreNodesAsSeeds(PairwiseImageGraph graph, int maxMotions) {
        this.seedScores.reset();
        HashMap<String, SeedInfo> mapScores = new HashMap<String, SeedInfo>();
        for (int idxView = 0; idxView < graph.nodes.size; ++idxView) {
            PairwiseImageGraph.View v = (PairwiseImageGraph.View)graph.nodes.get(idxView);
            SeedInfo info = (SeedInfo)this.seedScores.grow();
            this.scoreSeedAndSelectSet(v, maxMotions, info);
            mapScores.put(v.id, info);
        }
        return mapScores;
    }

    protected void selectAndSpawnSeeds(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams, PairwiseImageGraph pairwise, DogArray<SeedInfo> candidates, Map<String, SeedInfo> lookupInfo) {
        Collections.sort(candidates.toList());
        if (this.verbose != null) {
            double maxScore = ((SeedInfo)candidates.get((int)(candidates.size - 1))).score;
            double minScore = ((SeedInfo)candidates.get((int)0)).score;
            this.verbose.printf("Select Seeds: candidates.size=%d scores=(%.2f - %.2f)\n", candidates.size, minScore, maxScore);
        }
        int maxFailures = this.maximumSeedFailures.computeI((double)candidates.size);
        int rejectedNeighbor = 0;
        int rejectedClose = 0;
        int rejectedSpawn = 0;
        int successes = 0;
        for (int i = candidates.size() - 1; i >= 0 && rejectedSpawn < maxFailures; --i) {
            int j;
            SeedInfo s = (SeedInfo)candidates.get(i);
            if (s.neighbor || s.motions.isEmpty()) {
                ++rejectedNeighbor;
                continue;
            }
            boolean skip = false;
            for (j = 0; j < s.seed.connections.size; ++j) {
                if (!Objects.requireNonNull(lookupInfo.get((Object)((PairwiseImageGraph.Motion)s.seed.connections.get((int)j)).other((PairwiseImageGraph.View)s.seed).id)).neighbor) continue;
                ++rejectedClose;
                skip = true;
                break;
            }
            if (skip) continue;
            if (!this.spawnSceneFromSeed(dbSimilar, dbCams, pairwise, s)) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED: Spawn view.id='" + s.seed.id + "', remaining=" + i);
                }
                ++rejectedSpawn;
                continue;
            }
            if (this.verbose != null) {
                this.verbose.println("Successfully spawned view.id='" + s.seed.id + "', remaining=" + i);
            }
            for (j = 0; j < s.seed.connections.size; ++j) {
                Objects.requireNonNull(lookupInfo.get((Object)((PairwiseImageGraph.Motion)s.seed.connections.get((int)j)).other((PairwiseImageGraph.View)s.seed).id)).neighbor = true;
            }
            ++successes;
        }
        if (this.verbose != null) {
            this.verbose.printf("Seed Summary: candidates=%d, success=%d, failures: neighbor=%d close=%d spawn=%d\n", candidates.size, successes, rejectedNeighbor, rejectedClose, rejectedSpawn);
        }
    }

    protected abstract boolean spawnSceneFromSeed(LookUpSimilarImages var1, LookUpCameraInfo var2, PairwiseImageGraph var3, SeedInfo var4);

    protected SeedInfo scoreSeedAndSelectSet(PairwiseImageGraph.View target, int maxMotions, SeedInfo output) {
        output.seed = target;
        this.scoresMotions.reset();
        for (int i = 0; i < target.connections.size; ++i) {
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)target.connections.get(i);
            if (!m.is3D) continue;
            ((ScoreIndex)this.scoresMotions.grow()).set(m.score3D, i);
        }
        while (output.motions.size < maxMotions && !this.scoresMotions.isEmpty()) {
            double bestScore = 0.0;
            int bestMotion = -1;
            for (int i = 0; i < this.scoresMotions.size; ++i) {
                double score = ((ScoreIndex)this.scoresMotions.get((int)i)).score;
                PairwiseImageGraph.View va = ((PairwiseImageGraph.Motion)target.connections.get(((ScoreIndex)this.scoresMotions.get((int)i)).index)).other(target);
                boolean foundValid = true;
                for (int outIdx = 0; outIdx < output.motions.size; ++outIdx) {
                    int connIdx = output.motions.get(outIdx);
                    PairwiseImageGraph.View vb = ((PairwiseImageGraph.Motion)target.connections.get(connIdx)).other(target);
                    PairwiseImageGraph.Motion m = va.findMotion(vb);
                    if (m == null || !m.is3D) {
                        foundValid = false;
                        break;
                    }
                    score = Math.min(score, m.score3D);
                }
                if (!foundValid || score <= bestScore) continue;
                bestScore = score;
                bestMotion = i;
            }
            if (bestScore == 0.0) break;
            output.motions.add(((ScoreIndex)this.scoresMotions.removeSwap((int)bestMotion)).index);
            output.score += bestScore;
        }
        return output;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public ConfigLength getMaximumSeedFailures() {
        return this.maximumSeedFailures;
    }

    protected static class Expansion {
        public SceneWorkingGraph scene;
        public int openIdx;
        public double score;

        protected Expansion() {
        }

        public void reset() {
            this.scene = null;
            this.openIdx = -1;
            this.score = -1.0;
        }
    }

    protected static class SeedInfo
    implements Comparable<SeedInfo> {
        PairwiseImageGraph.View seed;
        double score;
        DogArray_I32 motions = new DogArray_I32();
        boolean neighbor = false;

        protected SeedInfo() {
        }

        public void reset() {
            this.seed = null;
            this.score = 0.0;
            this.motions.reset();
            this.neighbor = false;
        }

        @Override
        public int compareTo(SeedInfo o) {
            return Double.compare(this.score, o.score);
        }
    }
}

