/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.calib;

import boofcv.abst.calib.ImageResults;
import boofcv.abst.calib.PlanarCalibrationDetector;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.PlanarCalibrationTarget;
import boofcv.alg.geo.calibration.Zhang99OptimizationFunction;
import boofcv.alg.geo.calibration.Zhang99Parameters;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class CalibrateMonoPlanar {
    protected PlanarCalibrationDetector detector;
    protected boolean flipY;
    protected CalibrationPlanarGridZhang99 zhang99;
    protected PlanarCalibrationTarget target;
    protected boolean assumeZeroSkew;
    protected Zhang99Parameters foundZhang;
    protected IntrinsicParameters foundIntrinsic;
    protected List<List<Point2D_F64>> observations = new ArrayList<List<Point2D_F64>>();
    protected List<List<Point2D_F64>> observationsAdj = new ArrayList<List<Point2D_F64>>();
    protected List<ImageResults> errors;
    public boolean verbose = false;
    private int widthImg;
    private int heightImg;

    public CalibrateMonoPlanar(PlanarCalibrationDetector detector, boolean flipY) {
        this.detector = detector;
        this.flipY = flipY;
    }

    public void configure(PlanarCalibrationTarget target, boolean assumeZeroSkew, int numRadialParam) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.target = target;
        this.zhang99 = new CalibrationPlanarGridZhang99(target, assumeZeroSkew, numRadialParam);
    }

    public void reset() {
        this.observations = new ArrayList<List<Point2D_F64>>();
        this.errors = null;
        this.widthImg = 0;
        this.heightImg = 0;
    }

    public boolean addImage(ImageFloat32 image) {
        if (this.widthImg == 0) {
            this.widthImg = image.width;
            this.heightImg = image.height;
        } else if (this.widthImg != image.width || this.heightImg != image.height) {
            throw new IllegalArgumentException("All images must have the same shape");
        }
        if (!this.detector.process(image)) {
            return false;
        }
        int h = image.getHeight();
        List<Point2D_F64> points = this.detector.getPoints();
        ArrayList<Point2D_F64> adjusted = new ArrayList<Point2D_F64>();
        if (this.flipY) {
            for (Point2D_F64 p : points) {
                Point2D_F64 a = new Point2D_F64(p.x, (double)h - p.y - 1.0);
                adjusted.add(a);
            }
        } else {
            adjusted.addAll(points);
        }
        this.observations.add(points);
        this.observationsAdj.add(adjusted);
        return true;
    }

    public void removeLatestImage() {
        this.observations.remove(this.observations.size() - 1);
        this.observationsAdj.remove(this.observationsAdj.size() - 1);
    }

    public IntrinsicParameters process() {
        if (!this.zhang99.process(this.observationsAdj)) {
            throw new RuntimeException("Zhang99 algorithm failed!");
        }
        this.foundZhang = this.zhang99.getOptimized();
        this.errors = CalibrateMonoPlanar.computeErrors(this.observationsAdj, this.foundZhang, this.target.points);
        this.foundIntrinsic = this.foundZhang.convertToIntrinsic();
        this.foundIntrinsic.flipY = this.flipY;
        this.foundIntrinsic.width = this.widthImg;
        this.foundIntrinsic.height = this.heightImg;
        return this.foundIntrinsic;
    }

    public void printStatistics() {
        CalibrateMonoPlanar.printErrors(this.errors);
    }

    public static List<ImageResults> computeErrors(List<List<Point2D_F64>> observation, Zhang99Parameters param, List<Point2D_F64> grid) {
        Zhang99OptimizationFunction function = new Zhang99OptimizationFunction(param, grid, observation);
        double[] residuals = new double[grid.size() * observation.size() * 2];
        function.process(param, residuals);
        ArrayList<ImageResults> ret = new ArrayList<ImageResults>();
        int N = grid.size();
        int index = 0;
        for (int indexObs = 0; indexObs < observation.size(); ++indexObs) {
            ImageResults r = new ImageResults(N);
            double meanX = 0.0;
            double meanY = 0.0;
            double meanErrorMag = 0.0;
            double maxError = 0.0;
            for (int i = 0; i < N; ++i) {
                double errorMag;
                double errorX = residuals[index++];
                double errorY = residuals[index++];
                r.pointError[i] = errorMag = Math.sqrt(errorX * errorX + errorY * errorY);
                meanX += errorX;
                meanY += errorY;
                meanErrorMag += errorMag;
                if (!(maxError < errorMag)) continue;
                maxError = errorMag;
            }
            r.biasX = meanX /= (double)N;
            r.biasY = meanY /= (double)N;
            r.meanError = meanErrorMag /= (double)N;
            r.maxError = maxError;
            ret.add(r);
        }
        return ret;
    }

    public static void printErrors(List<ImageResults> results) {
        double totalError = 0.0;
        for (int i = 0; i < results.size(); ++i) {
            ImageResults r = results.get(i);
            totalError += r.meanError;
            System.out.printf("image %3d Euclidean ( mean = %7.1e max = %7.1e ) bias ( X = %8.1e Y %8.1e )\n", i, r.meanError, r.maxError, r.biasX, r.biasY);
        }
        System.out.println("Average Mean Error = " + totalError / (double)results.size());
    }

    public List<List<Point2D_F64>> getObservations() {
        return this.observations;
    }

    public List<ImageResults> getErrors() {
        return this.errors;
    }

    public Zhang99Parameters getZhangParam() {
        return this.foundZhang;
    }

    public IntrinsicParameters getIntrinsic() {
        return this.foundIntrinsic;
    }

    public PlanarCalibrationTarget getTarget() {
        return this.target;
    }

    public boolean isFlipY() {
        return this.flipY;
    }
}

