/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.DetectorInterestPointMulti;
import boofcv.abst.feature.detect.interest.FoundPointSO;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;

public class GeneralToInterestMulti<T extends ImageSingleBand, D extends ImageSingleBand>
implements DetectorInterestPointMulti<T> {
    protected EasyGeneralFeatureDetector<T, D> detector;
    protected double scale;
    protected FastQueue<Point2D_F64> foundMin = new FastQueue(10, Point2D_F64.class, true);
    protected FastQueue<Point2D_F64> foundMax = new FastQueue(10, Point2D_F64.class, true);
    protected FoundPointSO[] sets;

    public GeneralToInterestMulti(GeneralFeatureDetector<T, D> detector, double scale, Class<T> imageType, Class<D> derivType) {
        this.detector = new EasyGeneralFeatureDetector<T, D>(detector, imageType, derivType);
        this.scale = scale;
        if (detector.isDetectMinimums() && detector.isDetectMaximums()) {
            this.sets = new FoundPointSO[]{new FoundMin(), new FoundMax()};
        } else if (detector.isDetectMaximums()) {
            this.sets = new FoundPointSO[]{new FoundMax()};
        } else if (detector.isDetectMinimums()) {
            this.sets = new FoundPointSO[]{new FoundMin()};
        }
    }

    @Override
    public void detect(T input) {
        this.foundMin.reset();
        this.foundMax.reset();
        this.detector.detect(input, null);
        QueueCorner min = this.detector.getMinimums();
        for (int i = 0; i < min.size; ++i) {
            Point2D_I16 p = (Point2D_I16)min.get(i);
            ((Point2D_F64)this.foundMin.grow()).set((double)p.x, (double)p.y);
        }
        QueueCorner max = this.detector.getMaximums();
        for (int i = 0; i < max.size; ++i) {
            Point2D_I16 p = (Point2D_I16)max.get(i);
            ((Point2D_F64)this.foundMax.grow()).set((double)p.x, (double)p.y);
        }
    }

    @Override
    public int getNumberOfSets() {
        return this.sets.length;
    }

    @Override
    public FoundPointSO getFeatureSet(int set) {
        return this.sets[set];
    }

    private class FoundMax
    implements FoundPointSO {
        private FoundMax() {
        }

        @Override
        public int getNumberOfFeatures() {
            return GeneralToInterestMulti.this.foundMax.size;
        }

        @Override
        public Point2D_F64 getLocation(int featureIndex) {
            return (Point2D_F64)GeneralToInterestMulti.this.foundMax.get(featureIndex);
        }

        @Override
        public double getScale(int featureIndex) {
            return GeneralToInterestMulti.this.scale;
        }

        @Override
        public double getOrientation(int featureIndex) {
            return 0.0;
        }
    }

    private class FoundMin
    implements FoundPointSO {
        private FoundMin() {
        }

        @Override
        public int getNumberOfFeatures() {
            return GeneralToInterestMulti.this.foundMin.size;
        }

        @Override
        public Point2D_F64 getLocation(int featureIndex) {
            return (Point2D_F64)GeneralToInterestMulti.this.foundMin.get(featureIndex);
        }

        @Override
        public double getScale(int featureIndex) {
            return GeneralToInterestMulti.this.scale;
        }

        @Override
        public double getOrientation(int featureIndex) {
            return 0.0;
        }
    }
}

