/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.segmentation;

import boofcv.abst.segmentation.ImageSegmentation;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.segmentation.ComputeRegionMeanColor;
import boofcv.alg.segmentation.ImageSegmentationOps;
import boofcv.alg.segmentation.ms.MergeSmallRegions;
import boofcv.alg.segmentation.watershed.WatershedVincentSoille1991;
import boofcv.core.image.GConvertImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.feature.ColorQueue_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class Watershed_to_ImageSegmentation<T extends ImageBase>
implements ImageSegmentation<T> {
    private WatershedVincentSoille1991 alg;
    private ConnectRule rule;
    private ImageUInt8 converted = new ImageUInt8(1, 1);
    private MergeSmallRegions<ImageUInt8> pruneSmall;
    private GrowQueue_I32 regionMemberCount = new GrowQueue_I32();
    private FastQueue<float[]> regionColor = new ColorQueue_F32(1);
    private int numRegions;
    private ImageType<T> imageType;

    public Watershed_to_ImageSegmentation(WatershedVincentSoille1991 alg, int minimumSize, ConnectRule rule) {
        this.alg = alg;
        this.rule = rule;
        if (minimumSize > 0) {
            this.pruneSmall = new MergeSmallRegions<ImageUInt8>(minimumSize, rule, new ComputeRegionMeanColor.U8());
        }
    }

    @Override
    public void segment(T input, ImageSInt32 output) {
        InputSanityCheck.checkSameShape(input, (ImageBase)output);
        this.converted.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        GConvertImage.convert(input, (ImageBase)this.converted);
        this.alg.process(this.converted);
        this.alg.removeWatersheds();
        this.numRegions = this.alg.getTotalRegions();
        ImageSInt32 pixelToRegion = this.alg.getOutput();
        if (this.pruneSmall != null) {
            this.regionMemberCount.resize(this.numRegions);
            this.regionColor.resize(this.numRegions);
            ImageSegmentationOps.countRegionPixels(pixelToRegion, this.numRegions, this.regionMemberCount.data);
            this.pruneSmall.process(this.converted, pixelToRegion, this.regionMemberCount, this.regionColor);
            this.numRegions = this.regionMemberCount.size();
        }
        output.setTo((ImageSingleBand)pixelToRegion);
    }

    @Override
    public int getTotalSegments() {
        return this.numRegions;
    }

    @Override
    public ConnectRule getRule() {
        return this.rule;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType<T> imageType) {
        this.imageType = imageType;
    }
}

